//=====================================================================
// java PermutaApp.java
//=====================================================================

import java.lang.*; // predefinita

//---------------------------------------------------------------------
class PermutaApp {

    //-----------------------------------------------------------------
    static void permuta(int[] lista, int a, int z) {

	int scambio;
	int k;
	int i;

	//-------------------------------------------------------------
	// Se il segmento di array contiene almeno due elementi, si
	// procede.
	//-------------------------------------------------------------
	if ( (z - a) >= 1 ) {

	    //---------------------------------------------------------
	    // Inizia un ciclo di scambi tra l'ultimo elemento e uno
	    // degli altri contenuti nel segmento di array.
	    //---------------------------------------------------------
	    for ( k = z; k >= a; k-- ) {

		//-----------------------------------------------------
		// Scambia i valori
		//-----------------------------------------------------
		scambio = lista[k];
		lista[k] = lista[z];
		lista[z] = scambio;

		//-----------------------------------------------------
		// Esegue una chiamata ricorsiva per permutare un
		// segmento pi piccolo dell'array.
		//-----------------------------------------------------
		permuta( lista, a, z-1 );

		//-----------------------------------------------------
		// Scambia i valori
		//-----------------------------------------------------
		scambio = lista[k];
		lista[k] = lista[z];
		lista[z] = scambio;

	    }
	} else {

	    //---------------------------------------------------------
	    // Visualizza la situazione attuale dell'array.
	    //---------------------------------------------------------
	    for ( i = 0; i < lista.length; i ++ ) {
		System.out.print( " " + lista[i] );
	    }
	    System.out.println( "" );
	}
    }

    //=================================================================
    // Inizio del programma.
    //-----------------------------------------------------------------
    public static void main(String[] args) {

	int[] lista = new int[args.length];
	int i;

	//-------------------------------------------------------------
	// Conversione degli argomenti della riga di comando in
	// numeri.
	//-------------------------------------------------------------
	for ( i = 0; i < args.length; i ++ ) {
	    lista[i] = Integer.valueOf(args[i]).intValue();
	}

	//-------------------------------------------------------------
	// Esegue le permutazioni.
	//-------------------------------------------------------------
	permuta( lista, 0, args.length-1);
    }

}
//=====================================================================
