/* ================================================================= */
/* ricercabin <x> <v1>...					     */
/* Ricerca binaria.						     */
/* ================================================================= */

#include <stdio.h>

/* ================================================================= */
/* ricercabin ( <lista>, <elemento>, <inizio>, <fine> )		     */
/* ----------------------------------------------------------------- */
int ricercabin( int lista[], int x, int a, int z ) {

    int m;

    /* Determina l'elemento centrale.				     */
    m = ( a + z ) / 2;

    if ( m < a ) {
	/* Non restano elementi da controllare: l'elemento cercato   */
	/* non c'.						     */
        return -1;
    } else if ( x < lista[m] ) {
	/* Si ripete la ricerca nella parte inferiore.		     */
        return ricercabin ( lista, x, a, m-1 );
    } else if ( x > lista[m] ) {
        /* Si ripete la ricerca nella parte superiore.		     */
        return ricercabin ( lista, x, m+1, z );
    } else {
	/* m rappresenta l'indice dell'elemento cercato.	     */
        return m;
    }
}

/* ================================================================= */
/* Inizio del programma.					     */
/* ----------------------------------------------------------------- */
main( int argc, char *argv[] ) {

    int lista[argc-2];
    int x;
    int i;

    /* Acquisisce il primo argomento come valore da cercare.	     */
    sscanf( argv[1], "%d", &x );

    /* Considera gli argomenti successivi come gli elementi	     */
    /* dell'array da scandire.					     */
    for ( i = 2; i < argc; i++ ) {
	    sscanf( argv[i], "%d", &lista[i-2] );
    }

    /* Esegue la ricerca.					     */
    i = ricercabin( lista, x, 0, argc-2);

    /* Emette il risultato.					     */
    printf( "%d si trova nella posizione %d\n", x, i );
}
