import sys, glob, textwrap
def read_desktop(fname):
	'''Convert a .desktop file into a dict'''
	fobj = open(fname)
	contents = dict([k.strip().split("=", 1) for k in fobj if "=" in k])
	fobj.close()
	return contents

files = {}
for filename in glob.glob("menu-data/*.desktop"):
    pkg = read_desktop(filename)['X-AppInstall-Package']
    try:
        files[pkg].append(filename)
    except KeyError:
        files[pkg] = [filename]

for pkg in sorted(files):
    if len(files[pkg]) > 1:
        l = ', '.join(files[pkg])
        print '%30s' % pkg, ('\n' + ' ' * 31).join(files[pkg])
