/***************************************************************************
                           chatline.cpp - a chatline
                             -------------------
    begin                : Mon Jan 2 2004
    copyright            : (C) 2004 by Albert Astals Cid
    email                : astals11@terra.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
#include <qregexp.h>
#include <kdebug.h>
#include "chatline.h"


chatLine::chatLine(QWidget *parent, const char *name) : QLineEdit(parent, name),
m_textChanged(false),
m_matchIndex(0)
{
	pos = 0;
	connect(this, SIGNAL(returnPressed()), this, SLOT(addMessage()));
}

bool chatLine::event(QEvent *e)
{
	// tab presses don't reach keyPressEvent so we must intercept them here
	QKeyEvent *ke;
	ke = dynamic_cast<QKeyEvent*>(e);
	
	
	if (e -> type() == QEvent::KeyPress)
	{
		
		if (ke->text()[0].isLetter() || ke->text()[0].isDigit()) {
			m_textChanged = true;
		}
		
		int aux;
		switch (ke -> key())
		{
			case Qt::Key_Up:
				pos++;
				aux = list.count() - pos;
				if (aux >= 0) setText(list[aux]);
				else pos--;
				return true;
			break;
			
			case Qt::Key_Down:
				pos--;
				aux = list.count() - pos;
				if (pos == 0) setText("");
				else if (aux < (int)list.count()) setText(list[aux]);
				else pos++;
				return true;
				
			case Qt::Key_Backspace:
				m_textChanged = true;
				return QLineEdit::event(e);
			
				
			case Qt::Key_Tab:
				if (m_textChanged){
					int spacePos = text().findRev(QRegExp("[^a-zA-Z0-9]"), cursorPosition()) + 1;
					if ((cursorPosition() - spacePos) <= 0)
						return true;
					lastWord = text().mid(spacePos, cursorPosition() - spacePos);
					matches.clear();
					m_matchIndex = 0;
					for ( QStringList::Iterator it = p_names.begin(); it != p_names.end(); ++it ){
						if ((*it) == lastWord){
							if (spacePos == 0){
								QString newString = (*it) + ": ";
								int newPos = newString.length();
								newString += text().right(text().length() - cursorPosition());
								setText(newString);
								setCursorPosition(newPos);
							}
							return true;
						}
						if ((*it).startsWith(lastWord, false))
							matches.append(*it);
					}
					QString text = this->text();
					text = text.left(text.length() - lastWord.length());
					lastWord = matches[m_matchIndex];
					if (lastWord.length() > 0)
						setText(text.append(lastWord).append(": "));
					m_matchIndex++;
					m_textChanged = false;
					return true;
				}

				else {
					if (m_matchIndex >= matches.count())
						m_matchIndex = 0;
					QString text = this->text();
					text = text.left(text.length() - lastWord.length()-2);
					lastWord = matches[m_matchIndex];
					if (lastWord.length() > 0)
						setText(text.append(lastWord).append(": "));
					m_matchIndex++;
					return true;
				}
				break;
		}
	}
	else if (e -> type() == QEvent::AccelOverride)
	{
		// override up and down so we get the key events also
		switch (ke -> key())
		{
			case Qt::Key_Up:
			case Qt::Key_Down:
				ke -> accept();
		}
	}
	return QLineEdit::event(e);
}

void chatLine::addMessage()
{
	emit newMessage();
	pos = 0;
	list.append(text());
	setText("");
}

//#include "chatline.moc"
