/***************************************************************************
                          apollonbrowseitemview.cpp  -  description
                             -------------------
begin		: Dec 05 2003
copyright	: (C) 2002 by Bastiaan Naber, (C) 2002 by Robert Wittams
email		: bastiaan@ricardis.tudelft.nl
description	: 

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qregexp.h> 

#include "apollonbrowseviewitem.h"
#include "apollonutils.h"
#include "giftconnection.h"

ApollonBrowseViewItem::ApollonBrowseViewItem(QListViewItem *parent) :
  QListViewItem(parent)
{
}

ApollonBrowseViewItem::~ApollonBrowseViewItem()
{
}

QString ApollonBrowseViewItem::text(int col) const
{
	QString line;

	switch(col)
	{
		case 0:
			line = m_file;
			break;
		case 1:
			line = ApollonUtils::convertSize(m_size.toULong());
			break;
	}

	return line;
}

QString ApollonBrowseViewItem::key(int column, bool /*ascending*/) const
{
	switch (column)
	{
		case 0:
			return text(column).lower();
			break;
		case 1:
			return m_size.rightJustify(15, '0');
			break;
		default:
			return text(column);
			break;
	}
}

