/*
 * Copyright (C) 2005 Universitat d'Alacant / Universidad de Alicante
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <apertium/LexWrapper.H>

// static members

FILE **
LexWrapper::input;

FILE **
LexWrapper::output;

likeyylex 
LexWrapper::my_nt;

char **
LexWrapper::my_t;

likeyyflush
LexWrapper::my_flusher;
 
likeyycreate 
LexWrapper::my_create_buffer;

likeyyflush
LexWrapper::my_switcher;

likeyyflush
LexWrapper::my_destroyer;

int
LexWrapper::my_buf_size;

void 
LexWrapper::initClass(FILE **yyinptr, FILE **yyoutptr, 
	              likeyylex nt, char **t, likeyyflush flusher, 
		      likeyycreate create_buffer, likeyyflush switcher, 
		      likeyyflush destroyer, int buf_size)
{
  input = yyinptr;
  output = yyoutptr;
  my_nt = nt;
  my_t = t;
  my_flusher = flusher;
  my_create_buffer = create_buffer;
  my_switcher = switcher;
  my_destroyer = destroyer;
  my_buf_size = buf_size; 
}

void
LexWrapper::destroy()
{
//  fclose(myinput);
//  fclose(myoutput);
  my_destroyer(mybuffer);
  mybuffer = NULL;
  myinput = myoutput = NULL;
}

LexWrapper::LexWrapper(FILE *input_file, FILE *output_file)
{
  mybuffer = my_create_buffer(input_file, my_buf_size);
  myinput = input_file;
  myoutput = output_file;
}

LexWrapper::~LexWrapper()
{
  destroy();
}

void 
LexWrapper::flush()
{
  *output = myoutput;
  my_switcher(mybuffer);
  my_flusher(mybuffer);
}

int
LexWrapper::yylex()
{
  *output = myoutput;
  my_switcher(mybuffer);
  return my_nt();
}  

char * 
LexWrapper::yytext()
{
  return my_t[0];
}
