'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: trace.n,v 1.1 2000/10/16 21:58:42 kriston Exp $
'\" 
.so man.macros
.TH trace n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
trace \- Monitor variable accesses
.SH SYNOPSIS
\fBtrace \fIoption\fR ?\fIarg arg ...\fR?
.BE

.SH DESCRIPTION
.PP
This command causes Tcl commands to be executed whenever certain operations are
invoked.  At present, only variable tracing is implemented. The
legal \fIoption\fR's (which may be abbreviated) are:
.TP
\fBtrace variable \fIname ops command\fR
Arrange for \fIcommand\fR to be executed whenever variable \fIname\fR
is accessed in one of the ways given by \fIops\fR.  \fIName\fR may
refer to a normal variable, an element of an array, or to an array
as a whole (i.e. \fIname\fR may be just the name of an array, with no
parenthesized index).  If \fIname\fR refers to a whole array, then
\fIcommand\fR is invoked whenever any element of the array is
manipulated.  If the variable does not exist, it will be created but
will not be given a value, so it will be visible to \fBnamespace which\fR
queries, but not to \fBinfo exists\fR queries.
.RS
.PP
\fIOps\fR indicates which operations are of interest, and consists of
one or more of the following letters:
.TP
\fBr\fR
Invoke \fIcommand\fR whenever the variable is read.
.TP
\fBw\fR
Invoke \fIcommand\fR whenever the variable is written.
.TP
\fBu\fR
Invoke \fIcommand\fR whenever the variable is unset.  Variables
can be unset explicitly with the \fBunset\fR command, or
implicitly when procedures return (all of their local variables
are unset).  Variables are also unset when interpreters are
deleted, but traces will not be invoked because there is no
interpreter in which to execute them.
.PP
When the trace triggers, three arguments are appended to
\fIcommand\fR so that the actual command is as follows:
.CS
\fIcommand name1 name2 op\fR
.CE
\fIName1\fR and \fIname2\fR give the name(s) for the variable
being accessed:  if the variable is a scalar then \fIname1\fR
gives the variable's name and \fIname2\fR is an empty string;
if the variable is an array element then \fIname1\fR gives the
name of the array and name2 gives the index into the array;
if an entire array is being deleted and the trace was registered
on the overall array, rather than a single element, then \fIname1\fR
gives the array name and \fIname2\fR is an empty string.
\fIName1\fR and \fIname2\fR are not necessarily the same as the
name used in the \fBtrace variable\fR command:  the \fBupvar\fR
command allows a procedure to reference a variable under a
different name.
\fIOp\fR indicates what operation is being performed on the
variable, and is one of \fBr\fR, \fBw\fR, or \fBu\fR as
defined above.
.PP
\fICommand\fR executes in the same context as the code that invoked
the traced operation:  if the variable was accessed as part of a
Tcl procedure, then \fIcommand\fR will have access to the same
local variables as code in the procedure.  This context may be
different than the context in which the trace was created.
If \fIcommand\fR invokes a procedure (which it normally does) then
the procedure will have to use \fBupvar\fR or \fBuplevel\fR if it
wishes to access the traced variable.
Note also that \fIname1\fR may not necessarily be the same as the name
used to set the trace on the variable;  differences can occur if
the access is made through a variable defined with the \fBupvar\fR
command.
.PP
For read and write traces, \fIcommand\fR can modify
the variable to affect the result of the traced operation.
If \fIcommand\fR modifies the value of a variable during a
read or write trace, then the new value will be returned as the
result of the traced operation.
The return value from  \fIcommand\fR is ignored except that
if it returns an error of any sort then the traced operation
also returns an error with
the same error message returned by the trace command
(this mechanism can be used to implement read-only variables, for
example).
For write traces, \fIcommand\fR is invoked after the variable's
value has been changed; it can write a new value into the variable
to override the original value specified in the write operation.
To implement read-only variables, \fIcommand\fR will have to restore
the old value of the variable.
.PP
While \fIcommand\fR is executing during a read or write trace, traces
on the variable are temporarily disabled.
This means that reads and writes invoked by
\fIcommand\fR will occur directly, without invoking \fIcommand\fR
(or any other traces) again.
However, if \fIcommand\fR unsets the variable then unset traces
will be invoked.
.PP
When an unset trace is invoked, the variable has already been
deleted:  it will appear to be undefined with no traces.
If an unset occurs because of a procedure return, then the
trace will be invoked in the variable context of the procedure
being returned to:  the stack frame of the returning procedure
will no longer exist.
Traces are not disabled during unset traces, so if an unset trace
command creates a new trace and accesses the variable, the
trace will be invoked.
Any errors in unset traces are ignored.
.PP
If there are multiple traces on a variable they are invoked
in order of creation, most-recent first.
If one trace returns an error, then no further traces are
invoked for the variable.
If an array element has a trace set, and there is also a trace
set on the array as a whole, the trace on the overall array
is invoked before the one on the element.
.PP
Once created, the trace remains in effect either until the
trace is removed with the \fBtrace vdelete\fR command described
below, until the variable is unset, or until the interpreter
is deleted.
Unsetting an element of array will remove any traces on that
element, but will not remove traces on the overall array.
.PP
This command returns an empty string.
.RE
.TP
\fBtrace vdelete \fIname ops command\fR
If there is a trace set on variable \fIname\fR with the
operations and command given by \fIops\fR and \fIcommand\fR,
then the trace is removed, so that \fIcommand\fR will never
again be invoked.
Returns an empty string.
.TP
\fBtrace vinfo \fIname\fR
Returns a list containing one element for each trace
currently set on variable \fIname\fR.
Each element of the list is itself a list containing two
elements, which are the \fIops\fR and \fIcommand\fR associated
with the trace.
If \fIname\fR doesn't exist or doesn't have any traces set, then
the result of the command will be an empty string.

.SH KEYWORDS
read, variable, write, trace, unset
