 /* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MYSQLSOCKET_HPP
#define __MYSQLSOCKET_HPP

#include "include.hpp"
#include "mysqlDaemon.hpp"
#include "mysqlServer.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Store information for connecting to MySQL using a file-socket.
    @date Sun Feb 19 2006
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class MySQLSocket: public MySQLServer
{
public:
  /** Constructor.
      Store information about the file-socket and the MySQL server.
      @param _userName Name of database user.
      @param _passWord Password of database-user.
      @param _socketName Name of the socket for connecting to the server (for
      example <TT>/var/lib/mysql/mysql.sock</TT>). */
  MySQLSocket( const std::string &_userName,
               const std::string &_passWord,
               const std::string &_socketName,
               MySQLDaemonPtr _daemon = MySQLDaemonPtr() ) throw (Error);
  /// Destructor.
  virtual ~MySQLSocket(void);
  ///
  const std::string &getSocketName(void) const { return socketName; }
  ///
  virtual void connect( const std::string &database, MYSQL *m )
    throw (Error);
  ///
  MySQLDaemonPtr getDaemon(void) const { return daemon; }
protected:
  ///
  std::string socketName;
  ///
  MySQLDaemonPtr daemon;
};

/// Smart-Pointer referencing a MySQL-socket.
typedef boost::shared_ptr< MySQLSocket > MySQLSocketPtr;

///@}

#endif
