 /* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MYSQLNETWORK_HPP
#define __MYSQLNETWORK_HPP

#include "include.hpp"
#include "mysqlServer.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Store information for connecting to a MySQL server over the network.
    @date Sun Feb 19 2006
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class MySQLNetwork: public MySQLServer
{
public:
  /** Constructor.
      Store information for connecting to a MySQL server over the network.
      @param _userName Name of database user.
      @param _passWord Password of database-user.
      @param _serverName Name of the server hosting the database (for
      example <TT>localhost</TT>).
      @param _portNumber Server-port. */
  MySQLNetwork( const std::string &_userName,
                const std::string &_passWord,
                const std::string &_serverName,
                int _portNumber ) throw (Error);
  ///
  virtual ~MySQLNetwork(void);
  ///
  const std::string &getServerName(void) const { return serverName; }
  ///
  int getPortNumber(void) const { return portNumber; }
  ///
  virtual void connect( const std::string &database, MYSQL *m ) throw (Error);
protected:
  ///
  std::string serverName;
  ///
  int portNumber;
};

/// Smart-Pointer referencing a MySQL-server.
typedef boost::shared_ptr< MySQLNetwork > MySQLNetworkPtr;

///@}

#endif
