/* Copyright (C) 2002, 2003, 2004, 2005, 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __COMPILER_HPP
#define __COMPILER_HPP

#include <boost/shared_ptr.hpp>
#include <iostream>
#include <string>
#include "error.hpp"
#include "object.hpp"

/** @defgroup compilers Compilers
    The compilers are transforming recipes into different formats.
    @{ */
/** Base class for all compilers.
    @date Sun Jan 09 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class Compiler: public Object
{
public:
  /// Constructor.
  Compiler(void) {}
  ///
  virtual void translate( std::istream &inputStream,
                          std::ostream &outputStream ) const
    throw (Error) = 0;
  /// Wrapper function for convenience.
  std::string translate( const std::string &input ) const;
};

///
typedef boost::shared_ptr< Compiler > CompilerPtr;

///@}

#endif
