<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="xml" indent="no" version="1.0" encoding="UTF-8"/>
  
  <xsl:template match="/data">
    <sqlout>
      <xsl:apply-templates select="*"/>
    </sqlout>
  </xsl:template>
  
  <xsl:template match="version">
    <version>
      <xsl:value-of select="table/row/column"/>
    </version>
  </xsl:template>


  <!-- Retrieve recipes. -->
  <xsl:template match="query">
    <xsl:for-each select="title/table/row">
      <xsl:variable name="recipeid" select="column[position()=1]"/>
      <recipe>
        <title><xsl:value-of select="column[position()=2]"/></title>
        <categories>
          <xsl:for-each select="../../../categories/table/row[column[position()=1]=$recipeid]">
            <category>
              <xsl:value-of select="column[position()=2]"/>
            </category>            
          </xsl:for-each>
        </categories>
        <servings>
          <amount>
            <xsl:value-of select="column[position()=3]"/>
          </amount>
          <unit>
            <xsl:value-of select="column[position()=4]"/>
          </unit>
        </servings>
        <ingredients>
          <xsl:for-each select="../../../section/table/row[column[position()=1]=$recipeid]">
            <xsl:variable name="sectionid" select="column[position()=2]"/>
            <section>
              <xsl:if test="not(column[position()=3]='')">
                <title><xsl:value-of select="column[position()=3]"/></title>
              </xsl:if>
              <xsl:for-each select="../../../ingredient/table/row[column[position()=1]=$recipeid and column[position()=2]=$sectionid]">
                <ingredient>
                  <xsl:if test="not(column[position()=3]='' and column[position()=4]='')">
                    <amount>
                      <xsl:choose>
                        <xsl:when test="not(column[position()=3]='')">
                          <float>
                            <xsl:value-of select="column[position()=3]"/>
                          </float>
                        </xsl:when>
                        <xsl:otherwise>
                          <fraction>
                            <nominator>
                              <xsl:value-of select="column[position()=4]"/>
                            </nominator>
                            <denominator>
                              <xsl:value-of select="column[position()=5]"/>
                            </denominator>
                          </fraction>
                        </xsl:otherwise>
                      </xsl:choose>
                    </amount>
                  </xsl:if>
                  <xsl:if test="not(column[position()=6]='')">
                    <unit>
                      <xsl:value-of select="column[position()=6]"/>
                    </unit>
                  </xsl:if>
                  <name>
                    <xsl:value-of select="column[position()=7]"/>
                  </name>
                  <xsl:if test="not(column[position()=8]='')">
                    <prep>
                      <xsl:value-of select="column[position()=8]"/>
                    </prep>
                  </xsl:if>
                </ingredient>
              </xsl:for-each>
            </section>
          </xsl:for-each>
        </ingredients>
        <instructions>
          <xsl:for-each select="../../../instructions/table/row[column[position()=1]=$recipeid]">
            <section>
              <xsl:if test="not(column[position()=2]='')">
                <title><xsl:value-of select="column[position()=2]"/></title>
              </xsl:if>
              <xsl:call-template name="generate-paragraphs">
                <xsl:with-param name="text" select="column[position()=3]"/>
              </xsl:call-template>
            </section>
          </xsl:for-each>
        </instructions>
      </recipe>
    </xsl:for-each>
  </xsl:template>

  <!-- Search results are just to be copied. -->
  <xsl:template match="results">
    <results>
      <xsl:copy-of select="table[position()=last()]"/>
    </results>
  </xsl:template>

  <xsl:template match="delete">
    <delete>
      <xsl:for-each select="table/row/column">
        <id><xsl:value-of select="."/></id>
      </xsl:for-each>
    </delete>
  </xsl:template>

  <xsl:template match="recipe">
    <recipe>
      <id>
        <xsl:value-of select="table/row/column[position()=1]"/>
      </id>
      <title>
        <xsl:value-of select="table/row/column[position()=2]"/>
      </title>
    </recipe>
  </xsl:template>

  <xsl:template match="categories">
    <xsl:copy-of select="."/>
  </xsl:template>

  <xsl:template match="count">
    <xsl:value-of select="table/row/column"/>
  </xsl:template>

  <xsl:template match="statistics">
    <statistics>
      <recipes>
        <xsl:value-of select="table[position()=1]/row/column"/>
      </recipes>
      <categories>
        <xsl:value-of select="table[position()=2]/row/column"/>
      </categories>
      <edibles>
        <xsl:value-of select="table[position()=3]/row/column"/>
      </edibles>
    </statistics>
  </xsl:template>

  <!-- Convert newline- and colon-characters. -->
  <xsl:template name="generate-paragraphs">
    <xsl:param name="text"/>

    <xsl:choose>

      <xsl:when test="contains($text,'&#xA;')">
        <par><xsl:value-of select="substring-before($text,'&#xA;')"/></par>
        <xsl:call-template name="generate-paragraphs">
          <xsl:with-param name="text"
            select="substring-after($text,'&#xA;')"/>
        </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
        <xsl:if test="$text">
          <par><xsl:value-of select="$text"/></par>
        </xsl:if>
      </xsl:otherwise>

    </xsl:choose>
    
  </xsl:template>

  <xsl:template match="*"/>

</xsl:stylesheet>
