/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __DISPLAYWAITCURSOR
#define __DISPLAYWAITCURSOR

#include <qapplication.h>
#include <qcursor.h>

/** Helper class for displaying cursor.
    @date Thu Nov 25 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class DisplayWaitCursor
{
public:
  /** Constructor displays wait-cursor..
      The constructor calls
      \code
      QApplication::setOverrideCursor( QCursor( Qt::WaitCursor ) );
      \endcode
      to display a wait-cursor. */
  DisplayWaitCursor(void)
    { QApplication::setOverrideCursor( QCursor( Qt::WaitCursor ) ); }
  /** Destructor restores old cursor.
      The destructor calls
      \code
      QApplication::restoreOverrideCursor();
      \endcode
      to restore the old cursor. */
  ~DisplayWaitCursor(void) { QApplication::restoreOverrideCursor(); }
};

#endif
