# 3 Why do anarcho"-capitalists place little or no value on "equality"?

Murray Rothbard argues that _"the 'rightist' libertarian is not opposed to
inequality."_ [**For a New Liberty**, p. 47] In contrast, "leftist"
libertarians oppose inequality because it has harmful effects on individual
liberty.

Part of the reason "anarcho"-capitalism places little or no value on
"equality" derives from their definition of that term. Murray Rothbard defines
equality as:

> _"A and B are 'equal' if they are identical to each other with respect to a
given attribute... There is one and only one way, then, in which any two
people can really be 'equal' in the fullest sense: they must be identical in
**all** their attributes."_

He then points out the obvious fact that _"men are not uniform,. . . . the
species, mankind, is uniquely characterised by a high degree of variety,
diversity, differentiation: in short, inequality."_ [**Egalitarianism as a
Revolt against Nature and Other Essays**, p. 4, p.5]

In others words, every individual is unique. Something no egalitarian has ever
denied. On the basis of this amazing insight, he concludes that equality is
impossible (except "equality of rights") and that the attempt to achieve
"equality" is a "revolt against nature" -- as if any anarchist had ever
advocated such a notion of equality as being identical!

And so, because we are all unique, the outcome of our actions will not be
identical and so social inequality flows from natural differences and not due
to the economic system we live under. Inequality of endowment implies
inequality of outcome and so social inequality. As individual differences are
a fact of nature, attempts to create a society based on "equality" (i.e.
making everyone identical in terms of possessions and so forth) is impossible
and "unnatural."

Before continuing, we must note that Rothbard is destroying language to make
his point and that he is not the first to abuse language in this particular
way. In George Orwell's **1984**, the expression _"all men are created equal"_
could be translated into Newspeak, but it would make as much sense as saying
_"all men have red hair,"_ an obvious falsehood (see _"The Principles of
Newspeak"_ Appendix). It's nice to know that "Mr. Libertarian" is stealing
ideas from Big Brother, and for the same reason: to make critical thought
impossible by restricting the meaning of words.

"Equality," in the context of political discussion, does not mean "identical,"
it usually means equality of rights, respect, worth, power and so forth. It
does not imply treating everyone identically (for example, expecting an eighty
year old man to do identical work to an eighteen violates treating both with
respect as unique individuals). For anarchists, as Alexander Berkman writes,
_"equality does not mean an equal amount but equal **opportunity**. . . Do not
make the mistake of identifying equality in liberty with the forced equality
of the convict camp. True anarchist equality implies freedom, not quantity. It
does not mean that every one must eat, drink, or wear the same things, do the
same work, or live in the same manner. Far from it: the very reverse, in fact.
Individual needs and tastes differ, as appetites differ. It is **equal**
opportunity to satisfy them that constitutes true equality. Far from
levelling, such equality opens the door for the greatest possible variety of
activity and development. For human character is diverse, and only the
repression of this free diversity results in levelling, in uniformity and
sameness. Free opportunity and acting out your individuality means development
of natural dissimilarities and variations. . . . Life in freedom, in anarchy
will do more than liberate man merely from his present political and economic
bondage. That will be only the first step, the preliminary to a truly human
existence."_ [**The ABC of Anarchism**, p. 25]

Thus anarchists reject the Rothbardian-Newspeak definition of equality as
meaningless within political discussion. No two people are identical and so
imposing "identical" equality between them would mean treating them as
**unequals**, i.e. not having equal worth or giving them equal respect as
befits them as human beings and fellow unique individuals.

So what should we make of Rothbard's claim? It is tempting just to quote
Rousseau when he argued _"it is . . . useless to inquire whether there is any
essential connection between the two inequalities [social and natural]; for
this would be only asking, in other words, whether those who command are
necessarily better than those who obey, and if strength of body or of mind,
wisdom, or virtue are always found in particular individuals, in proportion to
their power or wealth: a question fit perhaps to be discussed by slaves in the
hearing of their masters, but highly unbecoming to reasonable and free men in
search of the truth."_ [**The Social Contract and Discourses**, p. 49] But a
few more points should be raised.

The uniqueness of individuals has always existed but for the vast majority of
human history we have lived in very egalitarian societies. If social
inequality did, indeed, flow from natural inequalities then **all** societies
would be marked by it. This is not the case. Indeed, taking a relatively
recent example, many visitors to the early United States noted its egalitarian
nature, something that soon changed with the rise of wage labour and
industrial capitalism (a rise dependent upon state action, we must add, -- see
section [8](append138.html)). This implies that the society we live in (its
rights framework, the social relationships it generates and so forth) has a
far more of a decisive impact on inequality than individual differences. Thus
certain rights frameworks will tend to magnify "natural" inequalities
(assuming that is the source of the initial inequality, rather than, say,
violence and force). As Noam Chomsky argues:

> _"Presumably it is the case that in our 'real world' some combination of
attributes is conducive to success in responding to 'the demands of the
economic system' . . . One might suppose that some mixture of avarice,
selfishness, lack of concern for others, aggressiveness, and similar
characteristics play a part in getting ahead [in capitalism]. . . Whatever the
correct collection of attributes may be, we may ask what follows from the
fact, if it is a fact, that some partially inherited combination of attributes
tends to material success? All that follows . . . is a comment on our
particular social and economic arrangements . . . The egalitarian might
responds, in all such cases, that the social order should be changes so that
the collection of attributes that tends to bring success no longer do so . . .
"_ [**The Chomsky Reader**, p. 190]

So, perhaps, if we change society then the social inequalities we see today
would disappear. It is more than probable that natural difference has been
long ago been replaced with **social** inequalities, especially inequalities
of property (which will tend to increase, rather than decrease, inequality).
And as we argue in section [8](append138.html) these inequalities of property
were initially the result of force, **not** differences in ability. Thus to
claim that social inequality flows from natural differences is false as most
social inequality has flown from violence and force. This initial inequality
has been magnified by the framework of capitalist property rights and so the
inequality within capitalism is far more dependent upon, say, the existence of
wage labour, rather than "natural" differences between individuals.

If we look at capitalism, we see that in workplaces and across industries
many, if not most, unique individuals receive identical wages for identical
work (although this often is not the case for women and blacks, who receive
less wages than male, white workers). Similarly, capitalists have deliberately
introduced wage inequalities and hierarchies for no other reason that to
divide (and so rule) the workforce (see section [D.10](secD10.html)). Thus, if
we assume egalitarianism **is** a revolt against nature, then much of
capitalist economic life is in such a revolt (and when it is not, the
"natural" inequalities have been imposed artificially by those in power).

Thus "natural" differences do not necessarily result in inequality as such.
Given a different social system, "natural" differences would be encouraged and
celebrated far wider than they are under capitalism (where, as we argued in
section [B.1](secB1.html), hierarchy ensures the crushing of individuality
rather than its encouragement) without any change in social equality. The
claim that "natural" differences generates social inequalities is question
begging in the extreme -- it takes the rights framework of society as a given
and ignores the initial source of inequality in property and power. Indeed,
inequality of outcome or reward is more likely to be influenced by social
conditions rather than individual differences (as would be the case in a
society based on wage labour or other forms of exploitation).

Another reason for "anarcho"-capitalist lack of concern for equality is that
they think that _"liberty upsets patterns"_ (see section
[2.5](append132.html#secf25), for example). It is argued that equality can
only be maintained by restricting individual freedom to make exchanges or by
taxation of income. However, what this argument fails to acknowledge is that
inequality also restricts individual freedom (see [next
section](append133.html#secf31), for example) and that the capitalist property
rights framework is not the only one possible. After all, money is power and
inequalities in terms of power easily result in restrictions of liberty and
the transformation of the majority into order takers rather than free
producers. In other words, once a certain level of inequality is reached,
property does not promote, but actually conflicts with, the ends which render
private property legitimate. Moreover, Nozick (in his "liberty upsets
patterns" argument) _"has produced . . . an argument for unrestricted private
property using unrestricted private property, and thus he begs the question he
tries to answer."_ [Andrew Kerhohan, _"Capitalism and Self-Ownership"_, from
**Capitalism**, p. 71] For example, a worker employed by a capitalist cannot
freely exchange the machines or raw materials they have been provided with to
use but Nozick does not class this distribution of "restricted" property
rights as infringing liberty (nor does he argue that wage slavery itself
restricts freedom, of course).

So in response to the claim that equality could only be maintained by
continuously interfering with people's lives, anarchists would say that the
inequalities produced by capitalist property rights also involve extensive and
continuous interference with people's lives. After all, as Bob Black notes
_"[y]our foreman or supervisor gives you more or-else orders in a week than
the police do in a decade"_ nevermind the other effects of inequality such as
stress, ill health and so on [**Libertarian as Conservative**]. Thus claims
that equality involves infringing liberty ignores the fact that inequality
also infringes liberty. A reorganisation of society could effectively minimise
inequalities by eliminating the major source of such inequalities (wage
labour) by self-management (see section [I.5.12](secI5.html#seci512) for a
discussion of "capitalistic acts" within an anarchist society). We have no
desire to restrict free exchanges (after all, most anarchists desire to see
the "gift economy" become a reality sooner or later) but we argue that free
exchanges need not involve the unrestricted property rights Nozick assumes. As
we argue in sections [2](append132.html) and [3.1](append133.html#secf31),
inequality can easily led to the situation where self-ownership is used to
justify its own negation and so unrestricted property rights may undermine the
meaningful self-determination (what anarchists would usually call "freedom"
rather than self-ownership) which many people intuitively understand by the
term "self-ownership".

Thus, for anarchists, the "anarcho"-capitalist opposition to equality misses
the point and is extremely question begging. Anarchists do not desire to make
humanity "identical" (which would be impossible and a total denial of liberty
**and** equality) but to make the social relationships between individuals
equal in **power.** In other words, they desire a situation where people
interact together without institutionalised power or hierarchy and are
influenced by each other "naturally," in proportion to how the (individual)
**differences** between (social) **equals** are applicable in a given context.
To quote Michael Bakunin, _"[t]he greatest intelligence would not be equal to
a comprehension of the whole. Thence results. . . the necessity of the
division and association of labour. I receive and I give -- such is human
life. Each directs and is directed in his turn. Therefore there is no fixed
and constant authority, but a continual exchange of mutual, temporary, and,
above all, voluntary authority and subordination."_ [**God and the State**, p.
33]

Such an environment can only exist within self-managed associations, for
capitalism (i.e. wage labour) creates very specific relations and institutions
of authority. It is for this reason anarchists are socialists (i.e. opposed to
wage labour, the existence of a proletariat or working class). In other words,
anarchists support equality precisely **because** we recognise that everyone
is unique. If we are serious about "equality of rights" or "equal freedom"
then conditions must be such that people can enjoy these rights and liberties.
If we assume the right to develop one's capacities to the fullest, for
example, then inequality of resources and so power within society destroys
that right simply because people do not have the means to freely exercise
their capacities (they are subject to the authority of the boss, for example,
during work hours).

So, in direct contrast to anarchism, right-Libertarianism is unconcerned about
any form of equality except "equality of rights". This blinds them to the
realities of life; in particular, the impact of economic and social power on
individuals within society and the social relationships of domination they
create. Individuals may be "equal" before the law and in rights, but they may
not be free due to the influence of social inequality, the relationships it
creates and how it affects the law and the ability of the oppressed to use it.
Because of this, all anarchists insist that equality is essential for freedom,
including those in the Individualist Anarchist tradition the
"anarcho"-capitalist tries to co-opt -- _"Spooner and Godwin insist that
inequality corrupts freedom. Their anarchism is directed as much against
inequality as against tyranny"_ and _"[w]hile sympathetic to Spooner's
individualist anarchism, they [Rothbard and David Friedman] fail to notice or
conveniently overlook its egalitarian implications."_ [Stephen L. Newman,
**Liberalism at Wit's End**, p. 74, p. 76]

Why equality is important is discussed more fully in the [next
section](append133.html#secf31). Here we just stress that without social
equality, individual freedom is so restricted that it becomes a mockery
(essentially limiting freedom of the majority to choosing **which** employer
will govern them rather than being free within and outside work).

Of course, by defining "equality" in such a restrictive manner, Rothbard's own
ideology is proved to be nonsense. As L.A. Rollins notes, _"Libertarianism,
the advocacy of 'free society' in which people enjoy 'equal freedom' and
'equal rights,' is actually a specific form of egalitarianism. As such,
Libertarianism itself is a revolt against nature. If people, by their very
biological nature, are unequal in all the attributes necessary to achieving,
and preserving 'freedom' and 'rights'. . . then there is no way that people
can enjoy 'equal freedom' or 'equal rights'. If a free society is conceived as
a society of 'equal freedom,' then there ain't no such thing as 'a free
society'."_ [**The Myth of Natural Law**, p. 36]

Under capitalism, freedom is a commodity like everything else. The more money
you have, the greater your freedom. "Equal" freedom, in the Newspeak-
Rothbardian sense, **cannot** exist! As for "equality before the law", its
clear that such a hope is always dashed against the rocks of wealth and market
power (see [next section](append133.html#secf31) for more on this). As far as
rights go, of course, both the rich and the poor have an "equal right" to
sleep under a bridge (assuming the bridge's owner agrees of course!); but the
owner of the bridge and the homeless have **different** rights, and so they
cannot be said to have "equal rights" in the Newspeak-Rothbardian sense
either. Needless to say, poor and rich will not "equally" use the "right" to
sleep under a bridge, either.

Bob Black observes in **The Libertarian as Conservative** that _"[t]he time of
your life is the one commodity you can sell but never buy back. Murray
Rothbard thinks egalitarianism is a revolt against nature, but his day is 24
hours long, just like everybody else's."_

By twisting the language of political debate, the vast differences in power in
capitalist society can be "blamed" not on an unjust and authoritarian system
but on "biology" (we are all unique individuals, after all). Unlike genes
(although biotechnology corporations are working on this, too!), human society
**can** be changed, by the individuals who comprise it, to reflect the basic
features we all share in common -- our humanity, our ability to think and
feel, and our need for freedom.

## 3.1 Why is this disregard for equality important?

Simply because a disregard for equality soon ends with liberty for the
majority being negated in many important ways. Most "anarcho"-capitalists and
right-Libertarians deny (or at best ignore) market power. Rothbard, for
example, claims that economic power does not exist; what people call
_"economic power"_ is _"simply the right under freedom to refuse to make an
exchange"_ [**The Ethics of Liberty**, p. 222] and so the concept is
meaningless.

However, the fact is that there are substantial power centres in society (and
so are the source of hierarchical power and authoritarian social relations)
which are **not the state.** The central fallacy of "anarcho"-capitalism is
the (unstated) assumption that the various actors within an economy have
relatively equal power. This assumption has been noted by many readers of
their works. For example, Peter Marshall notes that _"'anarcho-capitalists'
like Murray Rothbard assume individuals would have equal bargaining power in a
[capitalist] market-based society"_ [**Demanding the Impossible**, p. 46]
George Walford also makes this clear in his comments on David Friedman's **The
Machinery of Freedom**:

> _"The private ownership envisages by the anarcho-capitalists would be very
different from that which we know. It is hardly going too far to say that
while the one is nasty, the other would be nice. In anarcho-capitalism there
would be no National Insurance, no Social Security, no National Health Service
and not even anything corresponding to the Poor Laws; there would be no public
safety-nets at all. It would be a rigorously competitive society: work, beg or
die. But as one reads on, learning that each individual would have to buy,
personally, all goods and services needed, not only food, clothing and shelter
but also education, medicine, sanitation, justice, police, all forms of
security and insurance, even permission to use the streets (for these also
would be privately owned), as one reads about all this a curious feature
emerges: everybody always has enough money to buy all these things. _

>

> _"There are no public casual wards or hospitals or hospices, but neither is
there anybody dying in the streets. There is no public educational system but
no uneducated children, no public police service but nobody unable to buy the
services of an efficient security firm, no public law but nobody unable to buy
the use of a private legal system. Neither is there anybody able to buy much
more than anybody else; no person or group possesses economic power over
others. _

>

> _"No explanation is offered. The anarcho-capitalists simply take it for
granted that in their favoured society, although it possesses no machinery for
restraining competition (for this would need to exercise authority over the
competitors and it is an **anarcho**\- capitalist society) competition would
not be carried to the point where anybody actually suffered from it. While
proclaiming their system to be a competitive one, in which private interest
rules unchecked, they show it operating as a co-operative one, in which no
person or group profits at the cost of another."_ [**On the Capitalist
Anarchists**]

This assumption of (relative) equality comes to the fore in Murray Rothbard's
"Homesteading" concept of property (discussed in section
[4.1](append134.html#secf41)). "Homesteading" paints a picture of individuals
and families doing into the wilderness to make a home for themselves, fighting
against the elements and so forth. It does **not** invoke the idea of
transnational corporations employing tens of thousands of people or a
population without land, resources and selling their labour to others. Indeed,
Rothbard argues that economic power does not exist (at least under capitalism;
as we saw in section [2.1](append132.html#secf21) he does make -- highly
illogical -- exceptions). Similarly, David Friedman's example of a pro-death
penalty and anti-death penalty "defence" firm coming to an agreement (see
section [6.3](append136.html#secf63)) assumes that the firms have equal
bargaining powers and resources -- if not, then the bargaining process would
be very one-sided and the smaller company would think twice before taking on
the larger one in battle (the likely outcome if they cannot come to an
agreement on this issue) and so compromise.

However, the right-libertarian denial of market power is unsurprising. The
necessity, not the redundancy, of equality is required if the inherent
problems of contract are not to become too obvious. If some individuals
**are** assumed to have significantly more power than others, and if they are
always self-interested, then a contract that creates equal partners is
impossible -- the pact will establish an association of masters and servants.
Needless to say, the strong will present the contract as being to the
advantage of both: the strong no longer have to labour (and become rich, i.e.
even stronger) and the weak receive an income and so do not starve.

If freedom is considered as a function of ownership then it is very clear that
individuals lacking property (outside their own body, of course) loses
effective control over their own person and labour (which was, lets not
forget, the basis of their equal natural rights). When ones bargaining power
is weak (which is typically the case in the labour market) exchanges tend to
magnify inequalities of wealth and power over time rather than working towards
an equalisation.

In other words, "contract" need not replace power if the bargaining position
and wealth of the would-be contractors are not equal (for, if the bargainers
had equal power it is doubtful they would agree to sell control of their
liberty/time to another). This means that "power" and "market" are not
antithetical terms. While, in an abstract sense, all market relations are
voluntary in practice this is not the case within a capitalist market. For
example, a large company has a comparative advantage over small ones and
communities which will definitely shape the outcome of any contract. For
example, a large company or rich person will have access to more funds and so
stretch out litigations and strikes until their opponents resources are
exhausted. Or, if a local company is polluting the environment, the local
community may put up with the damage caused out of fear that the industry
(which it depends upon) would relocate to another area. If members of the
community **did** sue, then the company would be merely exercising its
property rights when it threatened to move to another location. In such
circumstances, the community would "freely" consent to its conditions or face
massive economic and social disruption. And, similarly, _"the landlords'
agents who threaten to discharge agricultural workers and tenants who failed
to vote the reactionary ticket"_ in the 1936 Spanish election were just
exercising their legitimate property rights when they threatened working
people and their families with economic uncertainty and distress. [Murray
Bookchin, **The Spanish Anarchists**, p. 260]

If we take the labour market, it is clear that the "buyers" and "sellers" of
labour power are rarely on an equal footing (if they were, then capitalism
would soon go into crisis -- see section [10.2](append1310.html#secf102)). In
fact, competition _"in labour markets is typically skewed in favour of
employers: it is a buyer's market. And in a buyer's, it is the sellers who
compromise."_ [Juliet B. Schor, **The Overworked American**, p. 129] Thus the
ability to refuse an exchange weights most heavily on one class than another
and so ensures that "free exchange" works to ensure the domination (and so
exploitation) of one party by the other.

Inequality in the market ensures that the decisions of the majority of within
it are shaped in accordance with that needs of the powerful, not the needs of
all. It was for this reason that the Individual Anarchist J.K. Ingalls opposed
Henry George's proposal of nationalising the land. Ingalls was well aware that
the rich could outbid the poor for leases on land and so the dispossession of
the working classes would continue.

The market, therefore, does not end power or unfreedom -- they are still
there, but in different forms. And for an exchange to be truly voluntary, both
parties must have equal power to accept, reject, or influence its terms.
Unfortunately, these conditions are rarely meet on the labour market or within
the capitalist market in general. Thus Rothbard's argument that economic power
does not exist fails to acknowledge that the rich can out-bid the poor for
resources and that a corporation generally has greater ability to refuse a
contract (with an individual, union or community) than vice versa (and that
the impact of such a refusal is such that it will encourage the others
involved to "compromise" far sooner). And in such circumstances, formally free
individuals will have to "consent" to be unfree in order to survive.

As Max Stirner pointed out in the 1840s, free competition _"is not 'free,'
because I lack the **things** for competition."_ [**The Ego and Its Own**, p.
262] Due to this basic inequality of wealth (of "things") we find that
_"[u]nder the **regime** of the commonality the labourers always fall into the
hands of the possessors . . . of the capitalists, therefore. The labourer
cannot **realise** on his labour to the extent of the value that it has for
the customer."_ [**Op. Cit.**, p. 115] Its interesting to note that even
Stirner recognises that capitalism results in exploitation. And we may add
that value the labourer does not _"realise"_ goes into the hands of the
capitalists, who invest it in more "things" and which consolidates and
increases their advantage in "free" competition.

To quote Stephan L. Newman:

> _"Another disquieting aspect of the libertarians' refusal to acknowledge
power in the market is their failure to confront the tension between freedom
and autonomy. . . Wage labour under capitalism is, of course, formally free
labour. No one is forced to work at gun point. Economic circumstance, however,
often has the effect of force; it compels the relatively poor to accept work
under conditions dictated by owners and managers. The individual worker
retains freedom [i.e. negative liberty] but loses autonomy [positive
liberty]."_ [**Liberalism at Wit's End**, pp. 122-123]

(As an aside, we should point out that the full Stirner quote cited above is
_"[u]nder the **regime** of the commonality the labourers always fall into the
hands of the possessors, of those who have at their disposal some bit of the
state domains (and everything possessible in State domain belongs to the State
and is only a fief of the individual), especially money and land; of the
capitalists, therefore. The labourer cannot **realise** on his labour to the
extent of the value that it has for the customer."_

It could be argued that we misrepresenting Stirner by truncating the quote,
but we feel that such a claim this is incorrect. Its clear from his book that
Stirner is considering the "minimal" state (_"The State is a - commoners'
State . . . It protects man . . .according to whether the rights entrusted to
him by the State are enjoyed and managed in accordance with the will, that is,
laws, of the State."_ The State _"looks on indifferently as one grows poor and
the other rich, unruffled by this alternation. As **individuals** they are
really equal before its face."_ [**Op. Cit.**, p. 115, p. 252]). As
"anarcho"-capitalists consider their system to be one of rights and laws
(particularly property rights), we feel that its fair to generalise Stirner's
comments into capitalism **as such** as opposed to "minimum state" capitalism.
If we replace "State" by "libertarian law code" you will see what we mean. We
have included this aside before any right-libertarians claim that we are
misrepresenting Stirner' argument.)

If we consider "equality before the law" it is obvious that this also has
limitations in an (materially) unequal society. Brian Morris notes that for
Ayn Rand, _"[u]nder capitalism . . . politics (state) and economics
(capitalism) are separated . . . This, of course, is pure ideology, for Rand's
justification of the state is that it 'protects' private property, that is, it
supports and upholds the economic power of capitalists by coercive means."_
[**Ecology &amp; Anarchism**, p. 189] The same can be said of
"anarcho"-capitalism and its "protection agencies" and "general libertarian
law code." If within a society a few own all the resources and the majority
are dispossessed, then any law code which protects private property
**automatically** empowers the owning class. Workers will **always** be
initiating force if act against the code and so "equality before the law"
reinforces inequality of power and wealth.

This means that a system of property rights protects the liberties of some
people in a way which gives them an unacceptable degree of power over others.
And this cannot be met merely by reaffirming the rights in question, we have
to assess the relative importance of various kinds of liberty and other values
we how dear.

Therefore right-libertarian disregard for equality is important because it
allows "anarcho"-capitalism to ignore many important restrictions of freedom
in society. In addition, it allows them to brush over the negative effects of
their system by painting an unreal picture of a capitalist society without
vast extremes of wealth and power (indeed, they often construe capitalist
society in terms of an ideal -- namely artisan production -- that is really
**pre**-capitalist and whose social basis has been eroded by capitalist
development). Inequality shapes the decisions we have available and what ones
we make:

> _"An 'incentive' is always available in conditions of substantial social
inequality that ensure that the 'weak' enter into a contract. When social
inequality prevails, questions arises about what counts as voluntary entry
into a contract . . . Men and women . . . are now juridically free and equal
citizens, but, in unequal social conditions, the possibility cannot be ruled
out that some or many contracts create relationships that bear uncomfortable
resemblances to a slave contract."_ [Carole Pateman, **The Sexual Contract**,
p. 62]

This ideological confusion of right-libertarianism can also be seen from their
opposition to taxation. On the one hand, they argue that taxation is wrong
because it takes money from those who "earn" it and gives it to the poor. On
the other hand, "free market" capitalism is assumed to be a more equal
society! If taxation takes from the rich and gives to the poor, how will
"anarcho"-capitalism be more egalitarian? That equalisation mechanism would be
gone (of course, it could be claimed that all great riches are purely the
result of state intervention skewing the "free market" but that places all
their "rags to riches" stories in a strange position). Thus we have a problem,
either we have relative equality or we do not. Either we have riches, and so
market power, or we do not. And its clear from the likes of Rothbard,
"anarcho"-capitalism will not be without its millionaires (there is, after
all, apparently nothing un-libertarian about _"organisation, hierarchy, wage-
work, granting of funds by libertarian millionaires, and a libertarian
party"_). And so we are left with market power and so extensive unfreedom.

Thus, for a ideology that denounces egalitarianism as a _"revolt against
nature"_ it is pretty funny that they paint a picture of "anarcho"-capitalism
as a society of (relative) equals. In other words, their propaganda is based
on something that has never existed, and never will, namely an egalitarian
capitalist society.

## 3.2 But what about "anarcho"-capitalist support for charity?

Yes, while being blind to impact of inequality in terms of economic and social
power and influence, most right-libertarians **do** argue that the very poor
could depend on charity in their system. But such a recognition of poverty
does not reflect an awareness of the need for equality or the impact of
inequality on the agreements we make. Quite the reverse in fact, as the
existence of extensive inequality is assumed -- after all, in a society of
relative equals, poverty would not exist, nor would charity be needed.

Ignoring the fact that their ideology hardly promotes a charitable
perspective, we will raise four points. Firstly, charity will not be enough to
countermand the existence and impact of vast inequalities of wealth (and so
power). Secondly, it will be likely that charities will be concerned with
"improving" the moral quality of the poor and so will divide them into the
"deserving" (i.e. obedient) and "undeserving" (i.e. rebellious) poor. Charity
will be forthcoming to the former, those who agree to busy-bodies sticking
their noses into their lives. In this way charity could become another tool of
economic and social power (see Oscar Wilde's **The Soul of Man Under
Socialism** for more on charity). Thirdly, it is unlikely that charity will be
able to replace all the social spending conducted by the state -- to do so
would require a ten-fold increase in charitable donations (and given that most
right-libertarians denounce the government for making them pay taxes to help
the poor, it seems unlikely that they will turn round and **increase** the
amount they give). And, lastly, charity is an implicate recognition that,
under capitalism, no one has the right of life -- its a privilege you have to
pay for. That in itself is enough to reject the charity option. And, of
course, in a system designed to secure the life and liberty of each person,
how can it be deemed acceptable to leave the life and protection of even one
individual to the charitable whims of others? (Perhaps it will be argued that
individual's have the right to life, but not a right to be a parasite. This
ignores the fact some people **cannot** work -- babies and some handicapped
people -- and that, in a functioning capitalist economy, many people cannot
find work all the time. Is it this recognition of that babies cannot work that
prompts many right-libertarians to turn them into property? Of course, rich
folk who have never done a days work in their lives are never classed as
parasites, even if they inherited all their money). All things considered,
little wonder that Proudhon argued that:

> _"Even charitable institutions serve the ends of those in authority
marvellously well. _

>

> _"Charity is the strongest chain by which privilege and the Government,
bound to protect them, holds down the lower classes. With charity, sweeter to
the heart of men, more intelligible to the poor man than the abstruse laws of
Political Economy, one may dispense with justice."_ [**General Idea of the
Revolution**, pp. 69-70]

As noted, the right-libertarian (passing) acknowledgement of poverty does not
mean that they recognise the existence of market power. They never ask
themselves how can someone be free if their social situation is such that they
are drowning in a see of usury and have to sell their labour (and so liberty)
to survive.

[‹ 2 What do "anarcho"-capitalists mean by "freedom"?](/afaq/append132.html
"Go to previous page" ) [up](/afaq/append13.html "Go to parent page" ) [4 What
is the right-libertarian position on private property? ›](/afaq/append134.html
"Go to next page" )

