/*
 *
 *  (c) COPYRIGHT INRIA, 1996-2001
 *  Please first read the full copyright statement in file COPYRIGHT.
 *
 */
 
/* 
 * locate what is designated in Concrete Image in unstructured mode.
 *
 * Author: I. Vatton (INRIA)
 *
 */

#include "ustring.h"
#include "libmsg.h"
#include "thot_sys.h"

#include "constmedia.h"
#include "typemedia.h"
#include "message.h"
#include "appdialogue.h"

#define THOT_EXPORT extern
#include "boxes_tv.h"
#include "frame_tv.h"
#include "platform_tv.h"
#include "appdialogue_tv.h"

#include "appli_f.h"
#include "structcreation_f.h"
#include "boxmoves_f.h"
#include "boxlocate_f.h"
#include "views_f.h"
#include "callback_f.h"
#include "font_f.h"
#include "geom_f.h"
#include "absboxes_f.h"
#include "buildboxes_f.h"
#include "buildlines_f.h"
#include "changepresent_f.h"
#include "boxselection_f.h"


#define MAX_DISTANCE 2000

/*----------------------------------------------------------------------
   GetClickedBox recherche recursivement le pave qui englobe le point 
   designe' par x,y.                                       
   La fonction regarde toute l'arborescence des paves      
   pour trouver le dernier pave de plus petite profondeur  
   couvrant le point designe.                              
   Si un pave et son fils repondent a la condition, c'est  
   le pave fils qui l'emporte.                             
  ----------------------------------------------------------------------*/
void   GetClickedBox (PtrBox * result, PtrAbstractBox pRootAb, int frame,
		      int x, int y, int *pointselect)
{
   PtrAbstractBox      pAb;
   PtrBox              pSelBox, pBox;
   PtrBox              graphicBox;
   int                 dist;
   int                 pointIndex;
   ViewFrame          *pFrame;
   int                 d;

   pBox = NULL;
   pSelBox = NULL;
   /* au-dela, on n'accepte pas la selection */
   dist = MAX_DISTANCE;
   pFrame = &ViewFrameTable[frame - 1];

   if (pFrame->FrAbstractBox != NULL)
     pBox = pFrame->FrAbstractBox->AbBox;

   if (pBox != NULL)
     {
       pBox = pBox->BxNext;
       while (pBox != NULL)
	 {
	   pAb = pBox->BxAbstractBox;
	   if (pAb->AbVisibility >= pFrame->FrVisibility)
	     {
	       pointIndex = 0;
	       graphicBox = NULL;
	       if (pAb->AbPresentationBox ||
		   pAb->AbLeafType == LtGraphics ||
		   pAb->AbLeafType == LtPolyLine ||
		   pAb->AbLeafType == LtPath)
		 {
		   graphicBox = GetEnclosingClickedBox (pAb, x, x, y, frame,
							&pointIndex);
		   if (graphicBox == NULL)
		     d = dist + 1;
		   else
		     d = 0;
		 }
	       else if (pAb->AbLeafType == LtSymbol && pAb->AbShape == 'r')
		 /* glitch pour le symbole racine */
		 d = GetShapeDistance (x, y, pBox, 1);
	       else if (pAb->AbLeafType == LtText ||
			pAb->AbLeafType == LtSymbol ||
			pAb->AbLeafType == LtPicture ||
			/* ou une boite composee vide */
			(pAb->AbLeafType == LtCompound && pAb->AbVolume == 0))
		 {
		   if (pAb->AbLeafType == LtPicture)
		     {
		       /* detecte si on selectionne la droite de l'image */
		       d = pBox->BxXOrg + (pBox->BxWidth / 2);
		       if (x > d)
			 pointIndex = 1;
		       d = GetBoxDistance (x, y, pBox->BxXOrg, pBox->BxYOrg,
					   pBox->BxWidth, pBox->BxHeight);
		     }
		   else
		     d = GetBoxDistance (x, y, pBox->BxXOrg, pBox->BxYOrg,
					 pBox->BxWidth, pBox->BxHeight);
		   /* limit the distance to MAX_DISTANCE */
		   if (d > dist && dist == MAX_DISTANCE)
		     dist = d;
		 }
	       else
		 d = dist + 1;
	       
	       /* Prend l'element le plus proche */
	       if (d < dist ||
		   (d == dist &&
		    (pSelBox == NULL ||
		     pSelBox->BxAbstractBox->AbDepth >= pBox->BxAbstractBox->AbDepth)))
		 {
		   dist = d;
		   pSelBox = pBox;
		   /* the selected reference point */
		   *pointselect = pointIndex;
		 }
	     }
	   pBox = pBox->BxNext;
	 }
       /* return the root box if there is no box selected */
       if (pSelBox == NULL)
	 pSelBox = pBox = pFrame->FrAbstractBox->AbBox;
     }
   *result = pSelBox;
}
