/* $Id: wmclose.c,v 1.11 2000/01/24 21:35:58 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmmain.h"
#include "wmclient.h"
#include "wmclose.h"
#include "wmdesign.h"
#include "wmbutton.h"
#include "wmaction.h"

GtkWidget *wm_close_button_new(GtkWidget *client)
{
    GtkWidget *close;

    wm_message("WmClose: button_new \n");

    close = wm_button_new_default(client);
    gtk_signal_connect(GTK_OBJECT(close), "press1", 
		       GTK_SIGNAL_FUNC(wm_action_close), client);
    return close;
}

GtkWidget *wm_close_button_new_with_xpm(GtkWidget *client, gchar *filename)
{
    GtkWidget *close;

    close = wm_close_button_new(client);
    wm_design_xpm_pack(close, filename);

    return close;
}

GtkWidget *wm_close_button_new_default(GtkWidget *client)
{
    GtkWidget *close;

    close = wm_close_button_new(client);
    wm_design_label_pack(close, " x ");

    return close;
}
