#ifndef __SND_SEQ_LOCK_H
#define __SND_SEQ_LOCK_H

typedef struct {
	int used;	/* counter */
	spinlock_t lock;
	wait_queue_head_t sleep;
} snd_use_lock_t;

void snd_use_lock_init(snd_use_lock_t *lockp);
void snd_use_lock_use(snd_use_lock_t *lockp);
void snd_use_lock_inc(snd_use_lock_t *lockp);
void snd_use_lock_free(snd_use_lock_t *lockp);
void snd_use_lock_wait(snd_use_lock_t *lockp, unsigned long *rflags);
void snd_use_lock_terminate(snd_use_lock_t *lockp);
#define snd_use_lock_wait_unlock(p,flags) spin_unlock_irqrestore(&(p)->lock, flags)

extern void snd_seq_sleep_in_lock(wait_queue_head_t *p, spinlock_t *lock);
extern long snd_seq_sleep_timeout_in_lock(wait_queue_head_t *p, spinlock_t *lock, long timeout);

#endif /* __SND_SEQ_LOCK_H */

