/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2001-2002 by Rene Villiger <rvilliger@smile.ch>,
*                            Prakash Dayal <prakash@comp-phys.org>,
*                            Matthias Troyer <troyer@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: fmatrix.h,v 1.8 2003/04/24 13:49:40 renev Exp $ */

#ifndef IETL_FMATRIX_H
#define IETL_FMATRIX_H

#include <cstddef>

#undef minor

namespace ietl
{

    template <class T>
    class FortranMatrix 
    {
      private:
         T* p;
         std::size_t n_;
         std::size_t m_;
      public:
         typedef std::size_t size_type;
         FortranMatrix(size_type n, size_type m) : n_(n), m_(m) { p = new T[m*n]; };
         ~FortranMatrix() { delete[] p; };
         T* data() { return p; };
         const T* data() const { return p; };
         T operator()(size_type i, size_type j) const { return p[i+j*n_]; };
         T& operator()(size_type i, size_type j) { return p[i+j*n_]; };
         void resize(size_type n, size_type m) { m_=m; n_=n; delete[] p; p = new T[m*n]; };
         size_type nrows() { return n_; };
         size_type ncols() { return m_; };
         size_type minor() { return n_; };
    };  
}
#endif

