/*****************************************************************************
*
* ALPS Project: Algorithms and Libraries for Physics Simulations
*
* ALPS Light Libraries
*
* Copyright (C) 2002-2003 by Synge Todo <wistaria@comp-phys.org>
*
* This software is part of the "ALPS Light" Libraries, public-domain
* part of the ALPS Libraries. If you need the full functionality of
* the ALPS Libraries, such as Lattice, Model, Scheduler, etc, please
* use the full version of ALPS Libraries, which is available from
* http://alps.comp-phys.org/.
*
* Permission is hereby granted, free of charge, to any person or organization
* obtaining a copy of the software and accompanying documentation covered by
* this license (the "Software") to use, reproduce, display, distribute,
* execute, and transmit the Software, and to prepare derivative works of the
* Software, and to permit third-parties to whom the Software is furnished to
* do so, all subject to the following:
*
* The copyright notices in the Software and this entire statement, including
* the above license grant, this restriction and the following disclaimer,
* must be included in all copies of the Software, in whole or in part, and
* all derivative works of the Software, unless such copies or derivative
* works are solely in the form of machine-executable object code generated by
* a source language processor.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
* FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT 
* SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
* FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE, 
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
* DEALINGS IN THE SOFTWARE.
*
*****************************************************************************/

/* $Id: fixed_capacity_traits.h,v 1.4 2004/03/16 15:12:25 wistaria Exp $ */

#ifndef ALPS_FIXED_CAPACITY_TRAITS_H
#define ALPS_FIXED_CAPACITY_TRAITS_H

#include <cstddef>
#include <boost/config.hpp>
#include <alps/fixed_capacity_fwd.h>

namespace std {

// forward declarations of std::stack, std::queue and std::priority_queue ---//

template<class T, class C> class stack;
template<class T, class C> class queue;
template<class T, class C, class Cmp> class priority_queue;

} // namespace std


namespace alps {

// traits class alps::fixed_capacity_traits --------------------------------//

template<class C>
struct fixed_capacity_traits {
  BOOST_STATIC_CONSTANT(bool, capacity_is_fixed = false);
};

// specializations for fixed_capacity_[vector,deque]

template<class T, std::size_t N, class C>
struct fixed_capacity_traits<fixed_capacity_vector<T, N, C> > {
  BOOST_STATIC_CONSTANT(bool, capacity_is_fixed = true);
  BOOST_STATIC_CONSTANT(std::size_t, static_max_size = N);
};


template<class T, std::size_t N, class C>
struct fixed_capacity_traits<fixed_capacity_deque<T, N, C> > {
  BOOST_STATIC_CONSTANT(bool, capacity_is_fixed = true);
  BOOST_STATIC_CONSTANT(std::size_t, static_max_size = N);
};

// specializations for adaptors using fixed_capacity_[vector,deque] as
// a base container

template<class T, class C>
struct fixed_capacity_traits<std::stack<T, C> >
  : public fixed_capacity_traits<C> {};

template<class T, class C>
struct fixed_capacity_traits<std::queue<T, C> >
  : public fixed_capacity_traits<C> {};

template<class T, class C, class Cmp>
struct fixed_capacity_traits<std::priority_queue<T, C, Cmp> >
  : public fixed_capacity_traits<C> {};

#ifndef BOOST_NO_INCLASS_MEMBER_INITIALIZATION
template <class C>
const bool fixed_capacity_traits<C>::capacity_is_fixed;

template<class T, std::size_t N, class C>
const bool fixed_capacity_traits<fixed_capacity_vector<T, N, C> >::capacity_is_fixed;

template<class T, std::size_t N, class C>
const std::size_t fixed_capacity_traits<fixed_capacity_vector<T, N, C> >::static_max_size;

template<class T, std::size_t N, class C>
const bool fixed_capacity_traits<fixed_capacity_deque<T, N, C> >::capacity_is_fixed;

template<class T, std::size_t N, class C>
const std::size_t fixed_capacity_traits<fixed_capacity_deque<T, N, C> >::static_max_size;
#endif

} // namespace alps

#endif // ALPS_FIXED_CAPACITY_TRAITS_H
