#!/bin/sh
# Restart with tclsh\
exec tclsh "$0" "$@"

# This is simple ICQ robot which reports certain information about
# unix machine status.
# It also automatically authorizes averyone who wants authorization.

package require icq 0.8.6

proc Event {event args} {
	if {[llength [info commands ICQ::$event]]} {
		eval ICQ::$event $args
	}
}

namespace eval ICQ {
	proc Incoming {type sender time message} {
		global cmd
		# list of available requests-commands
		set available {uname uptime who w date}
		puts "incoming message of type $type from $sender:\n$message"
		switch -- $type {
			authrequest {
				$cmd send authorization $sender grant	
			}
			text {
				if {[lsearch $available $message]!=-1} {
					set f [open "|$message"]
					set reply [read $f]
					close $f
				} else {
					set reply "Unknown command.\
						Available commands are:\
						[join $available {, }]"
				}
				puts "reply to $sender: $reply"
				$cmd send text $sender $reply
			}
			web { puts "do not reply on $type messages" }
		}
	}
	proc MyStatus {status} {
		if {$status!="offline"} {
			puts "robot is ready to reply"
		} else {
			puts "robot is offline"
		}
	}
}

# Replace uin and password with real ones
set cmd [icq::icq 00000 fake -event Event]
$cmd status online
vwait z
