// ---------------------------------------------------------------------------
// - cdir.hxx                                                                -
// - standard system library - c directory function definition               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (ALEPH_PLATFORM_PROCID == ALEPH_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif

// linux
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_LINUX)
#define  ALEPH_PLATFORM_RDIR "/"
#define  ALEPH_PLATFORM_DSEP '/'
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#include <stdio.h>
#endif

// solaris
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_SOLARIS)
#define  ALEPH_PLATFORM_RDIR "/"
#define  ALEPH_PLATFORM_DSEP '/'
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#endif

// freebsd
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_FREEBSD)
#define  ALEPH_PLATFORM_RDIR "/"
#define  ALEPH_PLATFORM_DSEP '/'
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <dirent.h>
#include <unistd.h>
#endif
