# ---------------------------------------------------------------------------
# - t_5502.als                                                              -
# - aleph:txt library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   sort test module
# @author amaury darsch

# get the library
interp:library "aleph-txt"

# this fucntion checks that a vector is sorted
const check-vector (v) {
  trans elem (v:get 0)
  for (i) (v) {
    assert (>= i elem) true
    elem:= i
  }
}

# create an unsorted vector
const v-i (Vector 7 5 3 4 1 8 0 9 2 6)
const v-c (Vector 'h' 'e' 'l' 'l' 'o')
const v-s (Vector "world" "hello" "bonjour")

# sort and check integer
aleph:txt:sort v-i
check-vector   v-i

# sort and check characters
aleph:txt:sort v-c
check-vector   v-c

# sort and check srings
aleph:txt:sort v-s
check-vector   v-s
