// ---------------------------------------------------------------------------
// - Method.cpp                                                              -
// - standard object library - generic method class implementation           -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Method.hpp"

namespace aleph {

  // create a new method with a quark

  Method::Method (const long quark, Object* object) {
    d_type        = QUARK;
    d_method.qval = quark;
    p_object      = Object::iref (object);
  }

  // create a new method with a method object

  Method::Method (Object* method, Object* object) {
    d_type        = OBJECT;
    d_method.oval = Object::iref (method);
    p_object      = Object::iref (object);
  }

  // destroy this method

  Method::~Method (void) {
    if (d_type == OBJECT) Object::dref (d_method.oval);
    Object::dref (p_object);
  }

  // return the class name

  String Method::repr (void) const {
    return "Method";
  }

  // make this method a shared object

  void Method::mksho (void) {
    if (p_shared != nilp) return;
    Object::mksho ();
    if (p_object != nilp) p_object->mksho ();
    if ((d_type == OBJECT) && (d_method.oval != nilp))
      d_method.oval->mksho ();
  }

  // apply this method with a set of arguments
  
  Object* Method::apply (Runnable* robj, Nameset* nset, Cons* args) {
    Object* result = nilp;
    switch (d_type) {
    case Method::QUARK:
      result = p_object->apply (robj, nset, d_method.qval, args);
      break;
    case Method::OBJECT:
      result = p_object->apply (robj, nset, d_method.oval, args);
      break;
    }
    return result;
  }
}
