# ---------------------------------------------------------------------------
# - t_6002.als                                                              -
# - aleph:sio library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   aleph:sio select test module
# @author amaury darsch

# get the library
interp:library "aleph-sio"

# create a temporary file
const tname (aleph:sio:absolute-path "tmp" (aleph:sio:tmp-name))
trans tfile (aleph:sio:OutputFile tname)

# open the input file 
const ifile (aleph:sio:InputFile "t_6001.als")
const ilen  (ifile:length)

# create a selector between the input and output
const sobj  (aleph:sio:Selector ifile tfile)
assert true (aleph:sio:selector-p sobj)

# simple check first
assert 1    (sobj:input-length)
assert 1    (sobj:output-length)
assert true (aleph:sio:input-p  (sobj:input-get  0))
assert true (aleph:sio:output-p (sobj:output-get 0))

# check that both are ready
trans  vobj  (sobj:wait-all 0)
assert 2     (vobj:length)

# clean the temporary file
aleph:sio:rmfile tname
