// ---------------------------------------------------------------------------
// - Libasio.cpp                                                             -
// - aleph:sio library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Libasio.hpp"
#include "Selector.hpp"
#include "Terminal.hpp"
#include "Function.hpp"
#include "Predasio.hpp"
#include "Pathasio.hpp"
#include "Directory.hpp"
#include "InputFile.hpp"
#include "OutputFile.hpp"
#include "InputMapped.hpp"
#include "InputString.hpp"
#include "OutputString.hpp"

namespace aleph {
  // initialize the sio library
  Object* init_aleph_sio (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;

    // create the aleph:sio nameset
    Nameset* aset = interp->mknset ("aleph", interp->getgset ());
    Nameset* asio = interp->mknset ("sio",   aset);

    // bind all symbols in the aleph.sio nameset
    asio->symcst ("Selector",        new Meta (Selector::mknew));
    asio->symcst ("Terminal",        new Meta (Terminal::mknew));
    asio->symcst ("Directory",       new Meta (Directory::mknew));
    asio->symcst ("InputFile",       new Meta (InputFile::mknew));
    asio->symcst ("InputTerm",       new Meta (InputTerm::mknew));
    asio->symcst ("ErrorTerm",       new Meta (OutputTerm::mkerr));
    asio->symcst ("OutputFile",      new Meta (OutputFile::mknew));
    asio->symcst ("OutputTerm",      new Meta (OutputTerm::mkout));
    asio->symcst ("InputMapped",     new Meta (InputMapped::mknew));
    asio->symcst ("InputString",     new Meta (InputString::mknew));
    asio->symcst ("OutputString",    new Meta (OutputString::mknew));

    // bind the predicates
    asio->symcst ("dir-p",           new Function (asio_dirp));
    asio->symcst ("file-p",          new Function (asio_filep));
    asio->symcst ("input-p",         new Function (asio_inputp));
    asio->symcst ("output-p",        new Function (asio_outputp));
    asio->symcst ("selector-p",      new Function (asio_selectp));
    asio->symcst ("terminal-p",      new Function (asio_termp));
    asio->symcst ("directory-p",     new Function (asio_odirp));
    asio->symcst ("input-file-p",    new Function (asio_ifilep));
    asio->symcst ("input-term-p",    new Function (asio_itermp));
    asio->symcst ("output-file-p",   new Function (asio_ofilep));
    asio->symcst ("output-term-p",   new Function (asio_otermp));
    asio->symcst ("input-string-p",  new Function (asio_inpstrp));
    asio->symcst ("input-mapped-p",  new Function (asio_inpmapp));
    asio->symcst ("output-string-p", new Function (asio_outstrp));

    // bind other functions
    asio->symcst ("rmdir",           new Function (asio_rmdir));
    asio->symcst ("rmfile",          new Function (asio_rmfile));
    asio->symcst ("tmp-name",        new Function (asio_tmp_name));
    asio->symcst ("absolute-path",   new Function (asio_absolute_path));
    asio->symcst ("relative-path",   new Function (asio_relative_path));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  aleph::Object* dli_aleph_sio (aleph::Interp* interp, aleph::Vector* argv) {
    return init_aleph_sio (interp, argv);
  }
}
