# ---------------------------------------------------------------------------
# - t_0034.als                                                              -
# - aleph engine test module                                                -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   a color class test module
# @author amaury darsch

const Color (class)
# class constructor
trans Color:initialize (red green blue) {
  const this:red   red
  const this:green green
  const this:blue  blue
}
# bind the scaling
const Color:RF 0.75
const Color:GF 0.75
const Color:BF 0.75

# this function return the max between two numbers
const max (x y) (if (> x y) x y)

# this method returns a darker color
trans Color:darker nil {
  trans lr (Integer (max (this:red:*   Color:RF) 0))
  trans lg (Integer (max (this:green:* Color:GF) 0))
  trans lb (Integer (max (this:blue:*  Color:BF) 0))
  Color lr lg lb
}

# this function check that two colors are equals
trans Color:== (color) {
  if (== Color color:meta) {
    if (!= this:red   color:red)   (return false)    
    if (!= this:green color:green) (return false)    
    if (!= this:blue  color:blue)  (return false)
    eval true
  } false
}

# create a new yellow color
const yellow (Color 255 255 0)
assert true (yellow:== (Color 255 255 0))
