//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef GUI_DIALOGS_SAVEDIALOG_H
#define GUI_DIALOGS_SAVEDIALOG_H

#include <qdialog.h>

//forward declarations
class QGridLayout;
class QLabel;
class QFrame;
class QListBox;
class QLineEdit;
class QTextBrowser;
class QPushButton;
class ClickableLabel;

//=====================================
/*! \brief Save dialog widget
 */
//=====================================

//======================
class SaveDialog : public QDialog
{
Q_OBJECT
//----------------------
public:
  SaveDialog( QString actionMessage, 
                    QString defaultPath,
                    QString defaultTheme,
                    QWidget *parent=0, 
                    const char* name=0);
  QString getTheme();
  QString getPath();
  static bool selectThemeAndPath(QString titleMessage,
                                                QString defaultPath,
                                                QString &theme, 
                                                QString &path);
  static bool themeAvailable(QString theme);                                               
//----------------------
signals:
  void dialogClosed();
private slots:
  void updatePreview();
  void save();
  void cancel();
  void prevScreenShot();
  void nextScreenShot();
  void browse();
//----------------------
private:
  QFrame *locationFrame, *themeSelectionFrame, *themePreviewFrame, *buttonsFrame;
  QGridLayout *locationGrid, *themeSelectionGrid, *themePreviewGrid, *mainGrid, *buttonsGrid;
  QLabel *locationLabel, *themeScreenShot, *themePreviewLabel, *themesLabel, *screenShotLabel;
  QLineEdit *locationVal;
  QListBox* themesList;
  QTextBrowser *themeFeatures;
  QPushButton *saveButton, *cancelButton;
  
  ClickableLabel *browseButton, *themeScreenPrev, *themeScreenNext;

  int previewNum;
  int numPreviews;
//----------------------
};
//======================

#endif //GUI_DIALOGS_SAVEDIALOG_H
