//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qimage.h>
#include <qstring.h>
#include <math.h>

//Projectwide includes
#include "invert.h"
#include "manipulationOptions.h"
#include "../../gui/statusWidget.h"

//----------------------------------------------
// Inputs:
// -------
// QString filename - location of original image on disk
// StatusWidget* status - widget for making progress visible to user
//
// Outputs:
// --------
// QImage* returned - constructed image
//
// Description:
// ------------
// This method constructs an inverted version of
// the image using Qt's invertPixels method. If we were
// to do this on our own special care to correctly handle the color
// depth would be necessary.
//----------------------------------------------

//==============================================
QImage* invertEffect( QString filename, ManipulationOptions* )
{
  //load image
  QImage* editedImage = new QImage( filename );
  
  //invert pixel colors, but not alpha components
  editedImage->invertPixels( false );
  
  //return pointer to edited image
  return editedImage;  
}
//==============================================
