#   _______   _______
#  /       \ /       \
# |         |         |
# |  The    |         |       Album Shaper 
# |  Album  | Project |       (c.) 2003-2005 Will Stokes
# |  Shaper |  File   |       wstokes (at) gmail (dot) com
# |         |         |       http://albumshaper.sf.net
# |  ______ |  _____  |
# |_/      \|_/     \_|

#===========================================================================================
#===========================================================================================
#
#                                    Installation options
#
#===========================================================================================
#===========================================================================================

# Directory binary (and possibly launcher script) will be installed
#-------------------------------------------------------
win32:BIN_DIR = AlbumShaper.win
mac:BUNDLE_DIR = build/AlbumShaper.app
!mac:unix:BIN_DIR = /usr/bin

#Directory translations, button icons, etc will be installed
#-------------------------------------------------------
win32:DATA_DIR     = AlbumShaper.win
mac:DATA_DIR       = $${BUNDLE_DIR}/Contents/Resources
!mac:unix:DATA_DIR = /usr/share/albumshaper

#===========================================================================================
#===========================================================================================
#
#                                    Compiling options 
#
#===========================================================================================
#===========================================================================================

#Comment this in if you want to manually set the include and linking paths
#CONFIG += manualPaths

#Comment this out if you don't want to UPX compress the binary
!mac:unix:CONFIG += useUpxCompression

#Comment this in if you want to link statically
#CONFIG += static

#Comment this line in if you want to compile using debugging symbols
#CONFIG += debug

#------------ Linux/FreeBSD Include Paths + Linking Options ---------------
!mac:unix {
  contains( CONFIG, manualPaths ) {
    INCLUDEPATH += ../libxml2/include
    INCLUDEPATH += ../libxslt
    INCLUDEPATH += ../libjpeg
    LIBS += ../libs/libjpeg.a
    LIBS += ../libs/libqt-mt.a
    LIBS += ../libs/libxslt.a
    LIBS += ../libs/libxml2.a
  } else {
    LIBXML2_INCLUDE        = $$system(xml2-config --cflags)
    LIBXSLT_INCLUDE        = $$system(xslt-config --cflags)
    QMAKE_CFLAGS_DEBUG     += $$LIBXML2_INCLUDE $$LIBXSLT_INCLUDE
    QMAKE_CXXFLAGS_DEBUG   += $$LIBXML2_INCLUDE $$LIBXSLT_INCLUDE
    QMAKE_CFLAGS_RELEASE   += $$LIBXML2_INCLUDE $$LIBXSLT_INCLUDE
    QMAKE_CXXFLAGS_RELEASE += $$LIBXML2_INCLUDE $$LIBXSLT_INCLUDE
    LIBS += -ljpeg
    LIBS += $$system(xslt-config --libs)  
    LIBS += $$system(xml2-config --libs)
    LIBS += -lxslt -lxml2 -ljpeg
  }
  release {
    TARGET = bin/AlbumShaper.bin 
  }
  debug {
    TARGET = bin/AlbumShaperDBG.bin 
  }
}
#------------------- Mac OSX Include + Linking Options --------------------
mac {
  #Force static building on Windows
  !debug { !contains( CONFIG, static ):CONFIG += static }
  
  !contains( CONFIG, static ):CONFIG += static

  INCLUDEPATH += ../libxml2/include
  INCLUDEPATH += ../libxslt
  INCLUDEPATH += ../libjpeg
  LIBS += -L../libs -F../libs

  static {
    contains( CONFIG, release ):LIBS += ../libs/libjpeg.a 
    LIBS += ../libs/libqt-mt.a
    LIBS += ../libs/libxslt.a
    LIBS += ../libs/libxml2.a
    LIBS += ../libs/libiconv.a
  } else {
    LIBS += -ljpeg -framework libxslt -framework libxml /usr/lib/libiconv.dylib
    INSTALLS += frameworks
  }

  #if debugging qt library already linked against libjpeg, also for some reason
  #we must link against the xml2.a file instead of the framework
  contains( CONFIG, debug ) {
    BUNDLE_DIR = build/AlbumShaperDBG.app
    DATA_DIR = $${BUNDLE_DIR}/Contents/Resources
    LIBS -= ../libs/libqt-mt.a
    LIBS -= -ljpeg
    LIBS -= "-framework libxml"
    LIBS += ../libs/libxml2.a
#   LIBS += /System/Library/Frameworks/CoreFoundation.framework/Versions/A/CoreFoundation
#   LIBS += /System/Library/Frameworks/Carbon.framework/Carbon
  }

  release {
    TARGET = build/AlbumShaper
  }
  debug {
    TARGET = build/AlbumShaperDBG
  }
}
#------------------- Windows Include + Linking Options --------------------
win32 {
  #Force static building on Windows
  !debug { !contains( CONFIG, static ):CONFIG += static }

  INCLUDEPATH += ../libxml2/include
  INCLUDEPATH += ../libxslt/include
  INCLUDEPATH += ../libjpeg/include
  INCLUDEPATH += ../iconv/include
  LIBS += ../libjpeg/lib/libjpeg.a
  LIBS += ../libxslt/lib/libxslt_a.lib
  LIBS += ../libxml2/lib/libxml2_a.lib
  LIBS += ../iconv/lib/iconv_a.lib

  release {
    TARGET = bin/AlbumShaper
  }
  debug {
    TARGET = bin/AlbumShaperDBG
  }
}

#===========================================================================================
#===========================================================================================
#
#                                     Translations
#
#===========================================================================================
#===========================================================================================

TRANSLATIONS = bin/translations/AlbumShaper_de.ts \
               bin/translations/AlbumShaper_es.ts \
               bin/translations/AlbumShaper_fr.ts \
               bin/translations/AlbumShaper_it.ts \
               bin/translations/AlbumShaper_nl.ts \
               bin/translations/AlbumShaper_pl.ts \
               bin/translations/AlbumShaper_ro.ts \
               bin/translations/AlbumShaper_ru.ts \
               bin/translations/AlbumShaper_sk.ts \
               bin/translations/AlbumShaper_sv.ts

#===========================================================================================
#===========================================================================================
#
#                      NO CHANGES SHOULD BE NECESSARY BELOW!
#
#===========================================================================================
#===========================================================================================

# Standard Qt project settings, plus threading support
TEMPLATE = app
CONFIG += qt thread
mac:CONFIG += link_prl

# If not compiling in debug mode add release to CONFIG string
!contains( CONFIG, debug ):CONFIG += release

# Debugging a statically linked binary is problematic, so disable static if debug enabled
contains(CONFIG, static):contains( CONFIG, debug):CONFIG -= static

#if UPX flag was set then setup running upx compression when releasing the binary
!mac:unix:release {
  contains( CONFIG, useUpxCompression ) {
    system(which upx > /dev/null && { exit 0; }):QMAKE_POST_LINK = upx $(TARGET)
  }
}

# Make sure static libraries are used for linking if static is set
!mac:unix:static {
  QMAKE_LFLAGS_RELEASE += -static
}

# Release optimizations
!debug {
  #Optimize compiled files for speed
  QMAKE_CFLAGS_RELEASE += -Os
  QMAKE_CXXFLAGS_RELEASE += -Os

  #Strip debug symbols from linked binaries - optionnot supported by nmake/vc6
  unix:QMAKE_LFLAGS_RELEASE += -s
}

# Define preprocessor variables specifying where items will be installed. This is
# needed to set up the MATERIAL_DIR variable which is used to load application resources
DEFINES += BIN_DIR=\"$$BIN_DIR\"
DEFINES += DATA_DIR=\"$$DATA_DIR\"

# xcopy is needed to properly copy directories in Windows
# /Y - supress overwrite confirm messages
# /K - copy attributes
# /E - copy all directories, even empty ones
# /Q - don't print out all filenames, faster
win32:QMAKE_COPY = xcopy /Y /K /E /Q

# Place moc and obj files in a tmp directory

release {
  MOC_DIR     = tmp
  OBJECTS_DIR = tmp
}
debug {
  MOC_DIR     = tmpDbg
  OBJECTS_DIR = tmpDbg
}
#===========================================================================================
#===========================================================================================
#
#                       Application Resources (and Frameworks)
#
#===========================================================================================
#===========================================================================================

#--------------------  Images -------------------------
win32:images.path  = $${DATA_DIR}/images
!win32:images.path = $${DATA_DIR}
images.files = bin/images

#---------- Text files for about dialog ---------------
win32:text.path  = $${DATA_DIR}/text
!win32:text.path = $${DATA_DIR}
text.files = bin/text

#------------------- Themes ---------------------------
win32:themes.path  = $${DATA_DIR}/themes
!win32:themes.path = $${DATA_DIR}
themes.files = bin/themes

#----------------- Translations -----------------------
win32:translations.path  = $${DATA_DIR}/translations
!win32:translations.path = $${DATA_DIR}
translations.files = bin/translations

#---------- XML/XSLT album update scripts -------------
win32:xmlConversion.path  = $${DATA_DIR}/xmlConversion
!win32:xmlConversion.path = $${DATA_DIR}
xmlConversion.files = bin/xmlConversion

#------------ Bundle frameworks (OSX) -----------------
mac:frameworks.path = $${BUNDLE_DIR}/Contents/Frameworks
mac:frameworks.files = ../libs/libxslt.framework
mac:frameworks.files += ../libs/libxml.framework

#---------- Custom Info.plist file (OSX) --------------
mac:plists.path = $${BUNDLE_DIR}/Contents
mac:plists.files = resources/macx/Info.plist

#-------- Application Icon (Windows / OSX ) -----------
win32:RC_FILE = resources/win32/AlbumShaper.rc
mac:RC_FILE = resources/macx/AlbumShaper.icns

#--------- Launcher Script (Linux/FreeBSD) ------------
!mac:unix:scripts.path = $${BIN_DIR}
!mac:unix:scripts.commands = cp -f bin/AlbumShaper $${BIN_DIR}/AlbumShaper;


#===========================================================================================
#===========================================================================================
#
#                                   Setup install target
#
#===========================================================================================
#===========================================================================================
win32:target.path = $$BIN_DIR
!mac:unix:target.path = $$BIN_DIR
!mac:INSTALLS += target

INSTALLS += images
INSTALLS += text
INSTALLS += themes
INSTALLS += translations
INSTALLS += xmlConversion

mac:INSTALLS += plists
!mac:unix:INSTALLS += scripts

#===========================================================================================
#===========================================================================================
#
#                                     Source Files
#
#===========================================================================================
#===========================================================================================

SOURCES += src/main.cpp \
           src/config.cpp \
           src/backend/album.cpp \
           src/backend/subalbum.cpp \
           src/backend/photo.cpp \
           src/backend/recentAlbums.cpp \
           src/backend/enhancements/color.cpp \
           src/backend/enhancements/contrast.cpp \
           src/backend/enhancements/redEye.cpp \
           src/backend/enhancements/tilt.cpp \
           src/backend/manipulations/blackWhite.cpp \
           src/backend/manipulations/blur.cpp \
           src/backend/manipulations/crop.cpp \
           src/backend/manipulations/edgeDetect.cpp \
           src/backend/manipulations/emboss.cpp \
           src/backend/manipulations/invert.cpp \
           src/backend/manipulations/mosaic.cpp \
           src/backend/manipulations/painting.cpp \
           src/backend/manipulations/pointillism.cpp \
           src/backend/manipulations/sepia.cpp \
           src/backend/manipulations/sharpen.cpp \
           src/backend/tools/fileTools.cpp \
           src/backend/tools/guiTools.cpp \            
           src/backend/tools/wallpaperTools.cpp \
           src/backend/tools/md5.cpp \
           src/backend/tools/xmlTools.cpp \
           src/backend/tools/imageTools.cpp \
           src/backend/tools/jpeg/jpegInternal.c \
           src/backend/tools/jpeg/jpegSize.cpp \
           src/backend/tools/jpeg/jpegTools.cpp \
           src/configuration/configuration.cpp \
           src/configuration/settinggroup.cpp \
           src/configuration/setting.cpp \
           src/configuration/configurationWidget.cpp \
           src/configuration/groupsWidget.cpp \
           src/configuration/groupIcon.cpp \
           src/configuration/alertsWidget.cpp \
           src/configuration/layoutSettingsWidget.cpp \
           src/configuration/loadingSavingWidget.cpp \
           src/configuration/miscSettings.cpp \
           src/gui/ALabel.cpp \
           src/gui/cursors.cpp \
           src/gui/clickableLabel.cpp \
           src/gui/blurSharpenSlider.cpp \
           src/gui/dynamicSlider.cpp \
           src/gui/layoutWidget.cpp \
           src/gui/photoDescEdit.cpp \
           src/gui/photoPreviewWidget.cpp \
           src/gui/photosIconView.cpp \
           src/gui/recentAlbumMenuItem.cpp \
           src/gui/statusWidget.cpp \
           src/gui/subalbumPreviewWidget.cpp \
           src/gui/subalbumsIconView.cpp \
           src/gui/subalbumsWidget.cpp \
           src/gui/subalbumWidget.cpp \
           src/gui/titleWidget.cpp \
           src/gui/window.cpp \
           src/gui/editing/editingInterface.cpp \
           src/gui/editing/selectionInterface.cpp \
           src/gui/editing/histogramEditor.cpp \
           src/gui/editing/grainEditor.cpp \
           src/gui/editing/splitViewInterface.cpp \
           src/gui/editing/scaledPreviewInterface.cpp \           
           src/gui/editing/panningPreviewInterface.cpp \
           src/gui/editing/selectionPlacementInterface.cpp \
           src/gui/editing/histogramInterface.cpp \
           src/gui/editing/manipulations/mosaicOptionsDialog.cpp \
           src/gui/dialogs/about.cpp \
           src/gui/dialogs/addPhotosDialog.cpp \
           src/gui/dialogs/albumStatistics.cpp \
           src/gui/dialogs/alertDialog.cpp \
           src/gui/dialogs/questionDialog.cpp \
           src/gui/dialogs/saveDialog.cpp \
           src/gui/help/helpWindow.cpp \
           src/gui/help/contents.cpp \
           src/gui/help/whatsNew.cpp \
           src/gui/help/importing.cpp \
           src/gui/help/annotating.cpp \
           src/gui/help/framing.cpp \
           src/gui/help/enhancing.cpp \
           src/gui/help/proTools.cpp \
           src/gui/help/manipulating.cpp \
           src/gui/help/loadSave.cpp \
           src/gui/help/shortcuts.cpp \
           src/gui/welcomeWindow/item.cpp \
           src/gui/welcomeWindow/items.cpp \
           src/gui/welcomeWindow/welcomeWindow.cpp

HEADERS += src/config.h \
           src/backend/album.h \
           src/backend/subalbum.h \
           src/backend/photo.h \
           src/backend/recentAlbums.h \
           src/backend/enhancements/color.h \
           src/backend/enhancements/contrast.h \
           src/backend/enhancements/redEye.h \
           src/backend/enhancements/redEye_internal.h \
           src/backend/enhancements/tilt.h \
           src/backend/enhancements/tilt_internal.h \
           src/backend/manipulations/blackWhite.h \
           src/backend/manipulations/blur.h \
           src/backend/manipulations/crop.h \
           src/backend/manipulations/edgeDetect.h \
           src/backend/manipulations/emboss.h \
           src/backend/manipulations/invert.h \
           src/backend/manipulations/manipulationOptions.h \
           src/backend/manipulations/mosaic.h \
           src/backend/manipulations/painting.h \
           src/backend/manipulations/pointillism.h \
           src/backend/manipulations/sepia.h \
           src/backend/manipulations/sharpen.h \
           src/backend/tools/fileTools.h \
           src/backend/tools/guiTools.h \            
           src/backend/tools/wallpaperTools.h \
           src/backend/tools/md5.h \
           src/backend/tools/xmlTools.h \
           src/backend/tools/imageTools.h \
           src/backend/tools/jpeg/jpegInternal.h \
           src/backend/tools/jpeg/jpegSize.h \
           src/backend/tools/jpeg/jpegTools.h \
           src/configuration/configuration.h \
           src/configuration/settinggroup.h \
           src/configuration/setting.h \
           src/configuration/configurationWidget.h \
           src/configuration/groupsWidget.h \
           src/configuration/groupIcon.h \
           src/configuration/alertsWidget.h \
           src/configuration/layoutSettingsWidget.h \
           src/configuration/loadingSavingWidget.h \
           src/configuration/miscSettings.h \
           src/gui/ALabel.h \
           src/gui/cursors.h \
           src/gui/clickableLabel.h \
           src/gui/blurSharpenSlider.h \
           src/gui/dynamicSlider.h \
           src/gui/layoutWidget.h \
           src/gui/photoDescEdit.h \
           src/gui/photoPreviewWidget.h \
           src/gui/photosIconView.h \
           src/gui/recentAlbumMenuItem.h \
           src/gui/statusWidget.h \
           src/gui/subalbumPreviewWidget.h \
           src/gui/subalbumsIconView.h \
           src/gui/subalbumsWidget.h \
           src/gui/subalbumWidget.h \
           src/gui/titleWidget.h \
           src/gui/window.h \
           src/gui/editing/editingInterface.h \
           src/gui/editing/selectionInterface.h \
           src/gui/editing/histogramEditor.h \
           src/gui/editing/grainEditor.h \
           src/gui/editing/splitViewInterface.h \
           src/gui/editing/scaledPreviewInterface.h \
           src/gui/editing/panningPreviewInterface.h \
           src/gui/editing/selectionPlacementInterface.h \
           src/gui/editing/histogramInterface.h \
           src/gui/editing/manipulations/mosaicOptionsDialog.h \
           src/gui/dialogs/about.h \
           src/gui/dialogs/addPhotosDialog.h \
           src/gui/dialogs/albumStatistics.h \
           src/gui/dialogs/alertDialog.h \
           src/gui/dialogs/questionDialog.h \
           src/gui/dialogs/saveDialog.h \
           src/gui/help/helpWindow.h \
           src/gui/help/contents.h \
           src/gui/help/whatsNew.h \
           src/gui/help/importing.h \
           src/gui/help/annotating.h \
           src/gui/help/framing.h \
           src/gui/help/enhancing.h \
           src/gui/help/proTools.h \
           src/gui/help/manipulating.h \
           src/gui/help/loadSave.h \
           src/gui/help/shortcuts.h \
           src/gui/welcomeWindow/item.h \
           src/gui/welcomeWindow/items.h \
           src/gui/welcomeWindow/welcomeWindow.h

#===========================================================================================
#===========================================================================================
#
#                  Print compilation and installation options
#
#===========================================================================================
#===========================================================================================

message('Compilation options:')
message('--------------------')
win32 {
  message( 'Using Win32 Include + Linking options' )
}
mac {
  message( 'Using Mac OSX Include + Linking options' )
}
!mac:unix {
  contains( CONFIG, manualPaths ) {
    message( 'Using manual Linux/FreeBSD include paths/linking options' )
  } else {
    message( 'Automatically determining Linux/FreeBSD include paths/linking options' )
  }
}

contains( CONFIG, debug             ):message('Including debug symbols')
contains( CONFIG, static            ):message('Statically linking binary')
contains( CONFIG, useUpxCompression ):message('Using UPX compression after binary has been built')
message('                     ')
message('Installation options:')
message('---------------------')
message('Launcher script.. $${BIN_DIR}/AlbumShaper')
mac {
  message('Bundle........... $${BUNDLE_DIR}') 
  message('Resources........ $${DATA_DIR}')
} else {
  message('Binary........... $${BIN_DIR}/AlbumShaper.bin')
  message('Resources........ $${DATA_DIR}')
}
message('                     ')
win32 {
  message('-> Constructing Makefile, when done run "nmake"    ')
} else {
  message('-> Constructing Makefile, when done run "make"    ')
}
