#   Alacarte Menu Editor - Simple fd.o Compliant Menu Editor
#   Copyright (C) 2005  Travis Watkins
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Library General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from config import *

class MenuHandler(object):
	def __init__(self, filename, options):
		self.filename = filename
		self.options = options

	def save(self):
		pass

	def new(self, item, parent):
		pass

class MenuItem(object):
	name = ''
	command = ''
	comment = ''
	icon = ''
	useTerm = False
	show = True
	backendId = None
	itemType = ALACARTE_IS_ENTRY
	fileType = ALACARTE_IS_LOCAL

	def __init__(self, backendId = None, itemType = None, fileType = None):
		if itemType != None:
			self.itemType = itemType
		if fileType != None:
			self.fileType = fileType
		self.backendId = backendId

	def __cmp__(self, other):
		if other == None:
			return -1
		if self.backendId == other.backendId:
			return 0
		return -1

	def getKey(self, key):
		pass

	def setKey(self, key, value):
		pass

	def getChildren(self):
		pass

	def isVisible(self):
		pass

	def toggleVisibility(self):
		pass

	def move(self, oldParent, newParent, before, after):
		pass

	def delete(self):
		pass

	def save(self):
		pass

	def revert(self):
		pass
