/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <glib.h>
#include <stdio.h>
#include "display.h"
#include "crack.h"

#define CRACK_COL 0
#define SSID_COL 1
#define NAME_COL 2
#define TIME_COL 3
#define IV_COL 4
#define CHAN_COL 5
#define TOTAL_COL 6
#define INTERESTING_COL 7
#define PWHEX_COL 8
#define PWASC_COL 9

int listCount;

//return a string version of the hex bytes held in key
//bytes are separated by a colon
char *toHex(unsigned char *key, int size) {
   static char str[50];
   char *ptr = str + 2;
   int i = 1;
   sprintf(str, "%2.2X", key[0]);
   for (; i < size; i++, ptr += 3) {
      sprintf(ptr, ":%2.2X", key[i]);
   }
   return str;
}

//return key as ascii. Non printable ascii characters are
//represented with a '.'
char *toAsc(unsigned char *key, int size) {
   static char str[15];
   char *ptr = str;
   int i = 0;
   for (; i < size; i++, ptr++) {
      sprintf(ptr, "%c", key[i] >= 32 && key[i] < 127 ? key[i] : '.');
   }
   return str;
}

//add a new SSID to the list of displayed SSIDs
void addList(BssidList *ptr, GtkCList *list) {
   static char chan[20];
   static char pkts[20];
   static char rsvled[20];
   static char *text[10] = {0,0,0,0,0,chan,pkts,rsvled,0,0};

   text[SSID_COL] = bssidtostr(ptr->bssid);
   text[NAME_COL] = ptr->name;
//   text[TIME_COL] = NULL;
   text[IV_COL] = ivtostr(ptr->lastiv);

   sprintf(chan, "%d", ptr->channel);
   sprintf(pkts, "%d", ptr->numPackets);
   sprintf(rsvled, "%d", ptr->interesting);

   gtk_clist_append(list, text);
}

//update an existing SSID with data collected over the last
//capture interval
void updateList(BssidList *ptr, GtkCList *list) {
   static char buf[20];

   if (ptr->name) {
     gtk_clist_set_text(list, ptr->rownum, NAME_COL, ptr->name);
   }

   gtk_clist_set_text(list, ptr->rownum, IV_COL, ivtostr(ptr->lastiv));

   sprintf(buf, "%d", ptr->numPackets);
   gtk_clist_set_text(list, ptr->rownum, TOTAL_COL, buf);

   sprintf(buf, "%d", ptr->interesting);
   gtk_clist_set_text(list, ptr->rownum, INTERESTING_COL, buf);

   sprintf(buf, "%d", ptr->channel);
   gtk_clist_set_text(list, ptr->rownum, CHAN_COL, buf);

   if (ptr->ap->cracked) {
      gtk_clist_set_text(list, ptr->rownum, CRACK_COL, "X");
      gtk_clist_set_text(list, ptr->rownum, PWHEX_COL, toHex(ptr->ap->curGuess, ptr->ap->cracked));
      gtk_clist_set_text(list, ptr->rownum, PWASC_COL, toAsc(ptr->ap->curGuess, ptr->ap->cracked));
   }

}

//The timer function installed to periodically update the capture
//statistics in the gui
int update(gpointer data) {
  int i = 0;
  BssidList *temp = head;

  for (; i < listCount; i++, temp = temp->next) {
     updateList(temp, (GtkCList *)data);
  }

  for (; temp; temp = temp->next) {
     addList(temp, (GtkCList *)data);
     listCount++;
  }
  return 1;
}

