/**********************************************************************
 ** main function: the main function that starts out the program
 **
 **
 **********************************************************************/

#ifndef CONVMAIN_C
#define CONVMAIN_C
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "convconfig.h"
#include "convmain.h"
#include "convstrings.h"
#include "aberpdirt.h"
#include "modules.h"

int main(int argc, char *argv[])
{
   int     i;
   int     has_read = 0;
   int     has_write = 0;
   Strings read_filename;
   Strings write_filename;
   Strings format;
   FILE    *read_file;
   FILE    *write_file;
   char    user_input[10];
   int     conv_all = 0;

   /* Show program info */
   printf("\033[1;37mZone file converter - "
          "(c) 1999, 2000 George Noel ("CONV_VERSION")\033[40m\033[0m\n");

   for (i=1; i < argc; i++)
   {
      /* if we have an option here */
      if (argv[i][0] == '-')
      {

	 /* if they are specifying a format */
         if (!strcasecmp("format", &argv[i][1]))
	 {
            i++;
            if ((i >= argc) || (argv[i][0] == '-'))
	    {
               show_formats();
               exit(0);
            }
            
            format = &argv[i][0];
         }
         else if (!strcasecmp("all", &argv[i][1]))
	 {
            conv_all = 1;
	 }
         else
	 {
            printf("Invalid option %s.\n", argv[i]);
            show_usage(argv[0]);
            exit(0);
         }
      }
      else
      {
         if (!has_read)
	 {
            read_filename = argv[i];
            has_read = 1;
         }
         else if (!has_write)
	 {
            write_filename = argv[i];
            has_write = 1;
         }
         else
	 {
            show_usage(argv[0]);
            exit(0);
         }
      }   
   }

   if (conv_all)
   {
      convert_all(format.str_show());
      exit(0);
   }

   if ((read_filename.str_show() == NULL) || 
       (write_filename.str_show() == NULL))
   {
      printf("You must state read and write filenames.\n");
      show_usage(argv[0]);
      exit(0);
   }

   if ((read_file = fopen(read_filename.str_show(), "r")) == NULL)
   {
      printf("Error opening read file '%s', it may not exist.\n", 
                                     read_filename.str_show());
      exit(0);
   }
   
   if ((write_file = fopen(write_filename.str_show(), "r")) != NULL)
   {
      printf("The file '%s' already exists, overwrite? (y/n) ", 
                                     write_filename.str_show());
      fgets(user_input, 10, stdin);
      if (user_input[0] != 'y')
      {
         printf("Okily dokily, not overwriting.\n");
         exit(0);
      }      
   }
   if (write_file != NULL)
      fclose(write_file);

   convert_file(read_file, write_filename.str_show(), format.str_show(),  
                                                  read_filename.str_show());

   if (read_file != NULL)
      fclose(read_file);
   if (write_file != NULL)
      fclose(write_file);

}


void show_usage(char *executeable)
{
   printf("\nUsage: %s [-all] [-format <format>] "
                                "[-all | <filename> <new_filename>]\n\n" 
       "       -format  : Format of file to convert.\n"
       "       -all     : Convert all area and data files\n\n", executeable);
}


void show_formats()
{
   int i = 0;

   printf("\nCurrent supported formats are: \n");
   while (mod_list[i].module_name != NULL)
   {
      printf("\t%s\n", mod_list[i].module_name);
      i++;
   }
   printf("\n\n");
}

#endif

























