/****************************************************************************
 ** AIME CONFIGURATION FILE
 **
 ** This is the main configuration file for the AIME codebase
 ** Here you set your directories and static defines, stuff that doesn't
 ** change all that often.  Other defines can be changed in the aime.conf
 ** file.
 ****************************************************************************/
#ifndef _CONFIG_H_
#define _CONFIG_H_

#ifndef WIN32
#include "autoconfig.h"
#endif

#include "gettext.h"

/*******************************************
 *          Version Information
 *******************************************/

#ifdef WIN32
#define PACKAGE  "AIME"
#define VERSION  "0.60.3"
#endif
#define FULLVERSION  PACKAGE"_v"VERSION

/********************************************
 **         Server Defines
 ********************************************/

#define USE_LINGER
#undef  NO_BUFFERING


/********************************************
 **         File location defines
 ********************************************/

// The following attempts to set your directory seperator properly
#if defined( WIN32 )
#  define DSEP "\\"
#  define NEWLINE "\r\n"
#else
#  define DSEP "/"
#  define NEWLINE "\n"
#endif


#define AREADIR	  "areas"     /* the areas directory */
#define BLDRDIR     "build"     /* where build files are saved */
#define DELFILE     "build" DSEP "delobj.bldr" /* where deleted objects are stored */

// These directory defines are defined in relation to the basedir, defined in
// the text config file aime.conf
#define LOGDIR           "logs"
#define BINDIR           "bin"
#define DATA_DIR         "data"
#define LOCALE_DIR       "locale"
#define LOGARCHIVE       LOGDIR DSEP "archives" DSEP
#define ERRLOGNAME       LOGDIR DSEP "errlog.txt"
#define SYSLOGNAME       LOGDIR DSEP "syslog.txt"
#define SUGGESTLOGNAME   LOGDIR DSEP "suggestlog.txt"
#define BUGLOGNAME       LOGDIR DSEP "buglog.txt"
#define TYPOLOGNAME      LOGDIR DSEP "typolog.txt"
#define BLDR_ACCESS_NAME DATA_DIR DSEP "bldraccess.txt"
#define GAME_ACCESS_NAME DATA_DIR DSEP "gameaccess.txt"
#define GAME_DATA        DATA_DIR DSEP "gamedata.txt"
#define EDITOR_HELP      DATA_DIR DSEP "editor.help"
#define INFODIR          DATA_DIR DSEP "info" DSEP
#define HELPDIR          DATA_DIR DSEP "help" DSEP
#define BANNERDIR        DATA_DIR DSEP "banner" DSEP
#define BOOKDIR          DATA_DIR DSEP "books" DSEP
#define BULLETINDIR      DATA_DIR DSEP "bulletins" DSEP
#define USERDATADIR      DATA_DIR DSEP "users"
#define INFOEXTENTION    ".info"
#define BOOKEXTENTION    ".book"
#define USEREXTENTION    ".user"
#define HELPEXTENTION    ".help"
#define BANNEREXTENTION  ".banr"
#define BULLEXTENTION    ".btn"

/**************************************************
 **      Debug defines
 **************************************************/

#undef DEBUG_MEM  // debugs memory usage, detecting leaks
#undef DEBUG_LOAD
#undef DEBUG_INPUT
#undef DEBUG_CONNECTION
#undef DEBUG_UDBASE
#undef DEBUG_FIGHT
#undef DEBUG_RELOAD
#define CRASH_ON_FAULT

#endif







