#ifndef _MARKER_H
#define _MARKER_H

#include "strings.h"
#include "item.h"
#include "builder.h"
#include "rope.h"

class Marker : public Item
{
public:

   Marker(char *the_name, char *the_area);
   virtual ~Marker();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int     copy_marker(Marker *copy_from);
   Marker  *operator = (Marker *copy_from); 
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

private:

   Marker();


};

#endif
