/*******************************************************************************
 *  PROJECT: Agave
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2006 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/
#ifndef __PALETTE_SELECTOR_H
#define __PALETTE_SELECTOR_H

#include <string>
#include <glibmm/ustring.h>
#include <gtkmm/combobox.h>
#include <gtkmm/liststore.h>

namespace gcs
{
    namespace Widgets
    {

        /** A ComboBox used to select a palette to display at the bottom of the
         * main application window.  This class reads the files from a specified
         * palette directory and verifies that they are valid palette files and
         * then displays a list of names in the ComboBox of available palettes
         * to choose from
         */
        class PaletteSelector :
            public Gtk::ComboBox
        {
            public:
                PaletteSelector(void);
                virtual ~PaletteSelector(void);

                std::string get_palette_file(void) const;
                void set_palette_file(const std::string& filename);

            protected:
                class ModelColumns : public Gtk::TreeModel::ColumnRecord
                {
                    public:
                        ModelColumns()
                        { add(m_columnName); add(m_columnFile); }
                        Gtk::TreeModelColumn<Glib::ustring> m_columnName;
                        Gtk::TreeModelColumn<std::string> m_columnFile;
                };

                ModelColumns m_columns;
                Glib::RefPtr<Gtk::ListStore> m_refListStore;
        };

    } // namespace Widgets
} // namespace gcs

#endif // __PALETTE_SELECTOR_H
