/* Io.h - Declarations for input redirection within af
   Copyright (C) 1995 - 2002 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/****************************************************************************/
/* RCS info */

#define IOID	"$Id: io.h,v 2.4 2002/08/21 23:54:48 malc Exp $"

/****************************************************************************/
/* The possible formats when writing a message */

#define WF_MBOX		0x01
#define WF_TEXT		0x02
#define WF_MESG		0x03
#define WF_SOME		0x04
#define WF_BODY		0x05

/* A macro to extract the basic format */

#define WF_FMT(f)	((f) & 0x07)

/* And flags that modify how we write the text */

#define WF_MMDF		0x0010
#define WF_NOBLANK	0x0020
#define WF_NOBODY	0x0040
#define WF_DECODE	0x0080
#define WF_SHOW		0x0100

/* And flags for warning about MIME stuff */

#define WF_WARN_MPART	0x1000
#define WF_WARN_TEXT	0x2000
#define WF_WARN_CSET	0x4000
#define WF_BODY_PART	0x8000

/* A macro to extract the MIME warning flags */

#define WF_WARN(f)	((f) & 0xF000)

/****************************************************************************/
/* The statuses returned by write-messages */

#define WM_OK		0
#define WM_RESYNC	1
#define WM_REREAD	2
#define WM_FAILED	3

/****************************************************************************/
/* The available options when confirming */

#define CONFIRM_OPTS	"yn"

/* And definitions for each option */

#define CONFIRM_YES	'y'
#define CONFIRM_NO	'n'

/* And definitions for long confirmation */

#define LCONFIRM_YES	"yes"
#define LCONFIRM_NO	"no"

/****************************************************************************/
/* The structure to hold the current input functions */

typedef struct iofunc {
	int (*key)();			/* Function to get a key */
	int (*type)();			/* Function to check for typeahead */
	char *(*line)();		/* Function to read a line */
	KEYSEQ *(*seq)();		/* Function to read a key sequence */
} IOFUNC;

/****************************************************************************/
