/* Enclist.h - List of header encodings for af's MIME handling.
   Copyright (C) 1996, 1997 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/****************************************************************************/
/* RCS info */

#ifndef lint
static char *EnclistId = "$Id: enclist.h,v 1.1 1997/09/07 00:38:47 malc Exp $";
#endif /* ! lint */

/****************************************************************************/
/* The structure we use to store details of header encoding */

typedef struct {
	char *header;			/* The header name */
	ATOM *(*tokeniser)();		/* How to tokenise the header */
	ATOM *(*recoder)();		/* How to recode the header */
	int break_at_commas;		/* Break at commas when refolding? */
} ENCODING;

/****************************************************************************/
/* Functions we might use to tokenise a header */

extern ATOM *tokenise(), *ctokenise();
extern ATOM *cttokenise(), *wtokenise();

/****************************************************************************/
/* Functions we use to encode or decode a header */

static ATOM *recode_all(), *recode_addresses();
static ATOM *recode_phrases(), *recode_comments();

/****************************************************************************/
/* And the list detailing how to encode or decode each header */

static ENCODING header_encodings[] = {
	{ RETURN_PATH, tokenise, recode_comments },
	{ FROM, tokenise, recode_addresses },
	{ SENDER, tokenise, recode_addresses },
	{ REPLY_TO, tokenise, recode_addresses },
	{ RESENT_FROM, tokenise, recode_addresses },
	{ RESENT_SENDER, tokenise, recode_addresses },
	{ RESENT_REPLY_TO, tokenise, recode_addresses },
	{ DATE, tokenise, recode_comments },
	{ RESENT_DATE, tokenise, recode_comments },
	{ TO, tokenise, recode_addresses },
	{ CC, tokenise, recode_addresses },
	{ BCC, tokenise, recode_addresses },
	{ RESENT_TO, tokenise, recode_addresses },
	{ RESENT_CC, tokenise, recode_addresses },
	{ RESENT_BCC, tokenise, recode_addresses },
	{ MESSAGE_ID, tokenise, recode_comments },
	{ RESENT_ID, tokenise, recode_comments },
	{ IN_REPLY_TO, tokenise, recode_phrases },
	{ REFERENCES, tokenise, recode_phrases },
	{ MIME_VERSION, tokenise, recode_comments },
	{ CONTENT_TYPE, ctokenise, recode_comments },
	{ C_T_ENCODING, ctokenise, recode_comments },
	{ CONTENT_DISP, tokenise, recode_comments },
	{ CONTENT_ID, tokenise, recode_comments },
	{ NULL, NULL, NULL }
};

/****************************************************************************/
