/*
 * genericmenu.cc
 * Copyright (C) 2000 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 18 Nov 2001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
#include "aewm.hh"

GenericMenu::GenericMenu() : BaseMenu()
{
	menuList = new LinkedList<BaseMenu>;
	menu_it.setList(menuList);
}

GenericMenu::~GenericMenu()
{
	menuList->removeAll();
	delete menuList;
}

BaseMenu* GenericMenu::findMenu(Window w)
{
	if (w && w != DefaultRootWindow(dpy)) {
		if(menuList->count()) 
		{
			menu_it.reset(); // reset the list to the beginning since we
				    // are reusing the iterator over and over
			
			for(; menu_it.current(); menu_it++)
			{
				if (w == menu_it.current()->getMenuWindow())
				{
					return menu_it.current();
				}				
			}
		}
	}

	return NULL;	
}
