/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <vidlist.h>
#include <stdio.h>

#define IDSTRING "VIdList: "


VIdList::VIdList()
{
	error=false;
	hasLast=false;
}

void VIdList::clear()
{
	uid.clear(); start.clear(); offset.clear();
}

int VIdList::count()
{
	return uid.count();
}

void VIdList::insert(QString UID, QDateTime s, long ofs, bool last)
{
	if(uid.count()==0)
	{
		hasLast=last;
		uid.append(UID); start.append(s); offset.append(ofs);
		return;
	}
	if(uid.count()==1)
	{
		int dx=0;
		if(s>start[0]) dx=1;
		// if I want to be the first element but it *has* to be last, then ERROR!
		if((!dx && last) || hasLast)
		{
			error=true;
			return;
		}
		hasLast=last;
		uid.insert(uid.at(dx),UID);
		start.insert(start.at(dx),s);
		offset.insert(offset.at(dx),ofs);
		hasLast=last;
		return;
	}
	if(s<start[0]) // then insert @ the head!
	{
		if(last) { error=true; return; }
		uid.insert(uid.at(0),UID);
		start.insert(start.at(0),s);
		offset.insert(offset.at(0),ofs);
		return;
	}
	int len=start.count()-1;
	if(s>start[len]) // then insert @ the head!
	{
		// if I have a date which has to be the last in the list...
		if(hasLast) { error=true; return; }
		uid.append(UID);
		start.append(s);
		offset.append(ofs);
		return;
	}
	// if it has the last flag but is not the last, return
	if(last && start[start.count()-1]>s) { error=true; return; }
	// insert inside the list...
	for(int i=1;i<uid.count();i++)
	{
		if((s>start[i-1]) && (s<=start[i]))
		{
			printf(IDSTRING"Insert %s @ %d\n",(const char *)UID,i);
			uid.insert(uid.at(i),UID);
			start.insert(start.at(i),s);
			offset.insert(offset.at(i),ofs);
			return;
		}
	}
}
long VIdList::operator [](const QDateTime &reference)
{
	if(reference < start[0])
		return -1;
	int o;
	for(o=1;(o<count()) && (start[o]<reference); o++);
	if(o==count())
		return -1;
	o--;
	return offset[o];
	
}
long VIdList::operator [](const QString &UID)
{
	int o;
	for(o=0;(o<count()) && (uid[o]!=UID); o++);
	if(o==count())
		return -1;
	return offset[o];
}
bool VIdList::isValid(const QString &UID, const QDateTime &reference)
{
	if (error)
		return true;
	int o;
	for(o=0;(o<count()) && (uid[o]!=UID); o++);
	if(o==count())
	{
		printf(IDSTRING"Unknown UID\n");
		return false;
	}
#ifdef DEBUG_VID
	printf(IDSTRING"offset: %d\n",o);
#endif
	if((o==0) && reference<start[o])
	{
		printf(IDSTRING"Less than the first occurence.\n");
		return false;
	}
	if(o!=(count()-1))
	{
#ifdef DEBUG_VID
		printf(IDSTRING"Somewhere in between...\n");
		printf(IDSTRING"prev: %s\n", (const char *)start[o].toString());
		printf(IDSTRING"ref : %s\n", (const char *)reference.toString());
		printf(IDSTRING"next: %s\n", (const char *)start[o+1].toString());
#endif
		if(reference>=start[o] && reference<start[o+1])
		{
#ifdef DEBUG_VID
			printf(IDSTRING"true\n");
#endif
			return true;
		}
		else
		{
#ifdef DEBUG_VID
			printf(IDSTRING"false\n");
#endif
			return false;
		}
	}
#ifdef DEBUG_VID
	printf(IDSTRING"The last element.\n");
#endif
	QDateTime tmp=start[0];
	// add one year
	tmp.setDate(QDate(start[0].date().year()+1,
							start[0].date().month(),
							start[0].date().day()));
	if(reference<tmp)
		return true;
	return false;
}

void VIdList::show()
{
	printf("-----------------------------------------------\n");
	for(int i=0;i<count();i++)
	printf("Element %03d: %10s  %s  %d\n", i,
			(const char *)uid[i], (const char *)start[i].toString(), offset[i]);
	printf("\n");
}




