/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef HAS_RDATE
#define HAS_RDATE

#include <qstring.h>
#include <qvaluelist.h>
#include <qdatetime.h>
#include <toolbox.h>


/*
 *	RDate object is used to parse the result of "RDATE;...:...." fields.
 */
class RDate
{
public:
	enum DateType { Interval=0, DateTime, Date };
	static Period Finished;

	/**
	 *	Constructor: it initializes the list of occurences by parsing the
	 * string. Also sets up the date (date/datetime/interval)
	 *	@param str the input string containing the recurecne dates
	 *	@param t the type of recurences - this is not used YET by the class
	 */
	RDate(const QString &str=QString::null, RDate::DateType t=DateTime);

	/**
	 *	Method provided for getting the next occurence (or today's occurence)
	 * of the event, based on the today's date.
	 *	@param	today the date from where should be considered the occurence
	 *	@return a @ref Period structure with the apropriate terms. If invalid, 
	 * reuturns the `Finished` instance.
	 */
	Period getNextOccurence(const QDateTime &today);

	/**
	 *	Method provided for getting the previous occurence (or before today)
	 * of the event, based on the today's date.
	 *	@param	today the date from where should be considered the occurence
	 *	@return a @ref Period structure with the apropriate terms. If invalid, 
	 * returns the `Finished` instance.
	 */
	Period getPreviousOccurence(const QDateTime &today);

	/**
	 *	Method provided for getting if the Period structures contain a DateTime
	 * or just a date.
	 */
	bool isDateOnly() { return dateOnly; }

protected:
	bool dateOnly;
	QValueList<Period> periods;
	DateType type;
	void parseString(const QString &dateTimeString);
	void setType(RDate::DateType newType);
	void setFinshed();

	/**
	 *	This method still has one unconsidered case: if the "today" is regarded
 	 * as a Date only (without the Time component). Hopefully this will never 
 	 * occur. If it does, it is considered as a DateTime with the components
 	 * (date)(00:00:00). Which may not be correct. Eventually the time should be
 	 * manually updated.
 	 */
	int getNextOccurencePrivate(const QDateTime &today);
};


#endif








