/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <lineedit.h>

GenericFieldEdit::GenericFieldEdit(QWidget *parent, const char *name):QWidget(parent, name)
{
	l=new QHBoxLayout(this, 3);
	label=new QLabel(this);
	e=new QLineEdit(this);
	label->setAlignment(AlignCenter);
	label->setFixedSize(75, 25);
	l->addWidget(label);
	l->addWidget(e);
	l->activate();
  connect(e, SIGNAL(textChanged(const QString &)), this, SLOT(emitTextChanged(const QString &)));
}

GenericFieldEdit::~GenericFieldEdit()
{
	delete(l);
	delete(e);
	delete(label);
}

void GenericFieldEdit::setLabelText(const QString &ltext)
{
	label->setText((const char *)ltext);
}

QString GenericFieldEdit::getLabelText()
{
	QString s=label->text();
	return s;
}

QString GenericFieldEdit::getText()
{
	QString s=e->text();
	return s;
}

void GenericFieldEdit::setText(QString text)
{
	e->setText((const char *)text);
}

bool GenericFieldEdit::isEmpty()
{
	QString s=e->text();
	return s.isEmpty();
}

void GenericFieldEdit::setLabelWidth(int w)
{
	label->setMinimumWidth(w);
	label->setMaximumWidth(w);
}

void GenericFieldEdit::emitTextChanged(const QString &t)
{
  emit(textChanged(t));
}




