/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <summaryframe.h>
#include <videotoolbox.h>
#include <definedmessages.h>
#include <qdir.h>
#include <qfiledialog.h>
#include <miscfunctions.h>
#include <simpleconfig.h>

extern VideoToolBox vtb;

void SummaryFrame::setResult(QStringList sl)
{
	// debug
	printf("Summary frame cfg:\n%s\n", (const char *)sl.join("\n"));
	
	QString result="<font color=#000000>&nbsp;&nbsp;&nbsp;&nbsp;The setup "
		"wizard has gathered all the required information.</font><br><br>"
			"Please review the settings:<br>";
	
	SimpleConfig cfg(sl);
	
	// installation directory
	cfg.setGroup("Choose Dir");
	result+="<br>Installation directory: "+cfg.readEntry("Directory");
	
	// identity
	cfg.setGroup("Identity");
	result+="<br>";
	result+="<br>Name: "+cfg.readEntry("Name");
	result+="<br>Email address: "+cfg.readEntry("Email");
	if(cfg.readEntry("Reply to")!=cfg.readEntry("Email"))
		result+="<br>Reply-To address: "+cfg.readEntry("Reply to");
	result+="<br>Organization: "+cfg.readEntry("Organization");
	result+="<br>Attach my card to outgoing mails: "+cfg.readEntry("Attach");
	
	// mail
	cfg.setGroup("Mailbox");
	result+="<br>";
	QString source=cfg.readEntry("Mailbox");
	if(source=="Local")
	{
		cfg.setGroup("Local Mail");
		result+="<br>Mail will be retrieved from a local mailbox";
		result+="<br>Mailbox path: "+cfg.readEntry("Mailbox");
	}
	else if(source=="POP3")
	{
		cfg.setGroup("POP3");
		result+="<br>Mail will be retrieved from a POP3 server";
		result+="<br>Server name: "+cfg.readEntry("Server")+" (port "+cfg.readEntry("Port")+")";
		result+="<br>User name: "+cfg.readEntry("UserName");
		result+="<br>Remember password: "+cfg.readEntry("RememberPassword");
		result+="<br>Leave messages on server: "+cfg.readEntry("LeaveOnServer");
		if(cfg.readEntry("LeaveOnServer")=="Yes")
		{
			result+="<br>Delete from server when deleted locally: "+cfg.readEntry("RemoteDelete");
			if(!cfg.readEntry("DeleteAfter").isEmpty())
				result+="<br>Delete from server: after "+cfg.readEntry("DeleteAfter")+" days";
		}
	}
	else
	{
		cfg.setGroup("IMAP");
		result+="<br>Mail will be retrieved from an IMAP4rev1 server";
		result+="<br>Server name: "+cfg.readEntry("Server")+" (port "+cfg.readEntry("Port")+")";
		result+="<br>User name: "+cfg.readEntry("UserName");
		result+="<br>Remember password: "+cfg.readEntry("RememberPassword");
		result+="<br>IMAP mailbox name: "+cfg.readEntry("Mailbox");
	}
	
	// smtp
	result+="<br>";
	cfg.setGroup("SMTP");
	result+="<br>SMTP server name: "+cfg.readEntry("Server")+" (port "+cfg.readEntry("Port")+")";

	result.append("<br>");
		
	result.append("<br>&nbsp;&nbsp;&nbsp;&nbsp;You can click \"Next\" to"
		" complete the setup by recording all the information you\'ve entered,"
		" \"Back\" to change any settings or \"Cancel\" to abort.");
	text->setText(result);
}

SummaryFrame::SummaryFrame(QWidget *parent, QString name,
	int x, int y, int dx, int dy, int idx) :
	QFrame(parent, name)
{
	index=idx;
	setGeometry(x, y, dx, dy);
	setFrameStyle(0);
	// Creating the continue-cancel buttons
	// The buttons are going to be in the bottom right
	int x,y;
	x=dx-280, y=dy-vtb.fontHeight();
	backButton=vtb.setUpQPushButton(this,"Back",
		80, vtb.fontHeight(), &x, &y);
	x=dx-180, y=dy-vtb.fontHeight();
	continueButton=vtb.setUpQPushButton(this,"Next",
		80, vtb.fontHeight(), &x, &y);
	continueButton->setDefault(true);
	x=dx-80, y=dy-vtb.fontHeight();
	finishButton=vtb.setUpQPushButton(this,"Cancel",
		80, vtb.fontHeight(), &x, &y);
	// create the text
	int DX=5, DY=5;
	vtb.setUpFonts(QFont("helvetica",12,QFont::Normal));
	text= vtb.setUpTextView(this, QFrame::Panel | QFrame::Sunken,
		backgroundColor(),
		"",
		width()-10,dy-vtb.fontHeight()-vtb.offsetY(),DX,DY);
	connect(backButton, SIGNAL(clicked()), this, SLOT(backClicked()));
	connect(finishButton, SIGNAL(clicked()), this, SLOT(finishClicked()));
	connect(continueButton, SIGNAL(clicked()), this, SLOT(continueClicked()));
}

void SummaryFrame::continueClicked()
{
	emit result(ContinueMessage, index, QStringList());
//	close();
	printf("Continue\n");
}

void SummaryFrame::finishClicked()
{
	emit result(CancelMessage, index, QStringList());
//	close();
	printf("Finish\n");
}

void SummaryFrame::backClicked()
{
	emit result(BackMessage, index, QStringList());
//	close();
	printf("Back\n");
}


