/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <servernotifier.h>
#include <conversions.h>
#include <commframe.h>
#include <servercommgate.h>
#include <commands.h>
#include <qtimer.h>

ServerNotifier *ServerNotifier::inst;

ServerNotifier *ServerNotifier::thisInstance()
{
	return inst?inst:(inst=new ServerNotifier);
}

ServerNotifier::ServerNotifier():QObject()
{
}

void ServerNotifier::trySend()
{
	if(ServerCommGate::thisInstance()->isLocked())
	{
		QTimer::singleShot(0, this, SLOT(trySend()));
	}
	else
	{
		while(!messageQueue.isEmpty())
		{
			NotifyMessage *msg=messageQueue.dequeue();
			
			CommFrame frame;

			frame.majorRevNo=1;
			frame.minorRevNo=1;
			frame.requestFrame=true;
			frame.serverFrame=true;
			frame.deniesReply=true;
			frame.hasData=true;
			frame.commandCode=msg->msgCode;
			frame.extraData=_stream(msg->objPath);
			
			delete msg;

			ServerCommGate::thisInstance()->sendMessage(frame);
		}
	}
}

void ServerNotifier::objectCreated(QString path)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::ObjectCreated;
	msg->objPath.append(path);
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::objectCreated(QStringList &paths)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::ObjectsCreated;
	msg->objPath=paths;
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::objectDeleted(QString path)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::ObjectDeleted;
	msg->objPath.append(path);
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::objectChanged(QString path)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::ObjectChanged;
	msg->objPath.append(path);
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::folderPurged(QString path)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::FolderPurged;
	msg->objPath.append(path);
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::folderCreated(QStringList &params)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::FolderCreated;
	msg->objPath=params;
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::folderDeleted(QStringList &params)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::FolderDeleted;
	msg->objPath=params;
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::hierarchyChanged(QString path)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::HierarchyChanged;
	msg->objPath.append(path);
	
	messageQueue.enqueue(msg);

	trySend();		
}

void ServerNotifier::ioProgress(QString message)
{
	NotifyMessage *msg=new NotifyMessage;
	
	msg->msgCode=MagellanComm::IOProgress;
	msg->objPath.append(message);
	
	messageQueue.enqueue(msg);

	trySend();		
}




