/***************************************************************************
                remotemailfolder.cpp  -  the remote mail folder class
                             -------------------
    begin                : Mon Mar  5 16:16:00 EET 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#ifndef REMOTEMAILFOLDER_H
#define REMOTEMAILFOLDER_H

#include <qstring.h>
#include <qcstring.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qdict.h>
#include <qlist.h>
#include <qmap.h>

#include <mailclasses.h>
#include <messageclass.h>
#include <mailfolder.h>
#include <imap4uidjar.h>

typedef struct IMAPStatus
{
  unsigned long messages;
  unsigned long recent;
  unsigned long unseen;
  unsigned long uidNext;
  unsigned long uidValidity;
} IMAP_STATUS;

class RemoteMailFolder : public MailFolder
{
	public:		
		RemoteMailFolder(const QString &_storageDevice);
		RemoteMailFolder(const QString &_storageDevice, const QString account, const QString mailbox);
		~RemoteMailFolder();

		/**The headers file name.*/
		QString getMessagesFileName() const;
		/** Get the account name.*/
		QString account() const;
		/** Get the mailbox name.*/
		QString mailbox() const;
		/** Create a new message based on the header information.*/
		IndexClass *createMessage(const QCString &text, const QCString &uid, const QDateTime &rcvtime,
		                          const QString &account=QString::null,MessageClass *parsedMessage = 0, bool bSync=false, const unsigned flags=0);
		bool updateMessage(const QCString &text, const QCString &uid);
		/** sync the messages from the list.*/
		void sync();
		/** Delete a message from the folder.*/
		bool deleteMessage(IndexClass *);
    /** Copy a message in this folder.*/
    IndexClass* copyMessage(IndexClass *idx);
    /** Move a message in this folder.*/
    IndexClass* moveMessage(IndexClass *idx);
		/** Expunge.*/
		bool expunge(bool force=false);
		
		// Status
		/** Messages number.*/
		unsigned long messages() const;
		/** The recent messages.*/
		unsigned long recent() const;
		/** The unseen messages.*/
		unsigned long unseen() const;
		/** The next uid message.*/
		unsigned long uidNext() const;
		/** The uid validity for the mailbox.*/
		unsigned long uidValidity() const;
		/** Set the folder status.*/
    void setStatus(unsigned long uidValidity,
                   unsigned long uidNext,
                   unsigned long messages,
                   unsigned long unseen,
                   unsigned long recent=0);
		/** Save the status to the file.*/
		bool saveStatus();
		
		//DEBUG
		void showStatus() const;
		
    // UIDs file
    IMAP4_UIDJar* uidJar;
	
	private:
	  // Methods
	  /** Set the files name.*/
		void setupFiles();
		/** Read the config file.*/
		void config();
		/** Make the config file.*/
		void makeConfig(QString account, QString mailbox);
		/** Load the index from the file.*/
		void loadIndex();
		/** Should expunge.*/
		bool shouldExpunge();
		/** Load the status from the file.*/
		bool loadStatus();
		
		// Attributes
		/**
		  * The headers file name.
		  * It keeps only the headers of the messages.
		  */
		QString headersFileName;
		/** The config file name.*/
		QString configFileName;
		/** IMAP account name.*/
		QString accountName;
		/** Mailbox name.*/
		QString mailboxName;
		/** IMAP status.*/
		IMAP_STATUS status;
};

#endif





