/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <orb.h>
#include <magellan.h>
#include <mailclasses.h>
#include <indexclass.h>
#include <transactionserver.h>
#include <attributemarshall.h>
#include <conversions.h>

QString ObjectRequestBroker::copy(QString url, QString dest_folder_url)
{
  if(!exists(url))
  {
    err="Cannot copy a non-existent object or folder";
    return QString::null;
  }
  if(!isFolder(dest_folder_url))
  {
    err="Cannot copy into a non-existent destination folder";
    return QString::null;
  }

  int stype=subtype(url);
  int dtype=subtype(dest_folder_url);

  if( stype!=dtype )
  {
    err="Cannot copy different type objects";
    return QString::null;
  }

  if(stype==Magellan::Message)
  {
    MailFolder *dfolder=mailfolderReference(dest_folder_url);
    IndexClass *idx=indexReference(url);

    if(!dfolder)
    {
      printf("Warning: URLManager::mailfolderReference() returned null when a valid pointer was expected, bailing out\n");
      err="Internal error in URLManager::mailfolderReference()";
      return QString::null;
    }
		
    if(!idx)
    {
      printf("Warning: URLManager::indexReference() returned null when a valid pointer was expected, bailing out\n");
      err="Internal error in URLManager::indexReference()";
      return QString::null;
    }

    // copy the message
    err="Internal error in LocalMailFolder::copyMessage()";
		
		// debug
		printf("orb: copying message %s/%s into %s...\n", (const char *)idx->getID(), (const char *)idx->getParentFolder()->getStorageDevice(), (const char *)dfolder->getStorageDevice());
		
    IndexClass *tidx=dfolder->copyMessage(idx);

    if(!tidx)
      return QString::null;

    QString tobj=tidx->getID();
    if(dest_folder_url[dest_folder_url.length()-1]!='/')
      tobj.prepend("/");
    tobj.prepend(dest_folder_url);

    return tobj;
	}
  else
	{
  	QString tobj=createObject(dest_folder_url);
  	if(tobj.isEmpty())
    	return QString::null; // the error message should be set by createObject()

  	QByteArray data;
  	if(!getObjectData(url, data)) return QString::null;
  	if(!setObjectData(dest_folder_url+"/"+tobj, data)) return QString::null;

  	return tobj;
	}
}

