/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __MessageDevice__
#define __MessageDevice__

#include <qstring.h>
#include <qstringlist.h>
#include <qcstring.h>
#include <messagedescriptor.h>

/** Int Values List.*/
typedef QValueList<int> IVList;

class IndexClass;
class MimePart;

class MessageDevice
{
	public:
		MessageDevice(IndexClass *);
	
		int getPartCount();
		int createPart();
		bool deletePart(int);
		bool getPartData(int, QByteArray &);
		bool setPartData(int, const QByteArray &);
		MimePart& operator[](int);
		
		MessageDescriptor& getDescriptor();
		void loadDescriptor(bool fast=false);
		void saveDescriptor();
				
    /** Return true if there are text parts.
      * The list will keep the text parts id.
      * If the list is NULL you just make a test.
      */
    bool textPart( IVList* textPartList = NULL );
    /** Return the part id for the message text.
      * Return -1 if there isn't a message text part.
      */
    int messageText();
    /** Return true if there are html parts.
      * The list will keep the html parts id.
      * If the list is NULL you just make a test.
      */
    bool htmlPart( IVList* htmlPartList = NULL );
    /** Return the true if there are text parts. */
    bool hasText();
    /** Return the true if there are html text parts. */
    bool hasHtml();
    /** Return the text from all the text message parts.*/
    QCString text(bool bAllTextParts=false);
    /** Return the html text for all text or html message parts.*/
    QCString html(bool bAllHTMLParts=false);
    
		bool hasAttachments();
		
		QCString rfc822Message();
		QCString rfc822Header();
		
		QByteArray getEntryCacheBlock();
	private:
		IndexClass *_index;
		MessageDescriptor _descriptor;
};

#endif
