/***************************************************************************
            imap4uidjar.cpp  -  the UID jar class for IMAP4 folders
                             -------------------
    begin                : Wed Mar 14 19:02:00 EET 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#include <imap4uidjar.h>

IMAP4_UIDJar::IMAP4_UIDJar(const char *urlFolder) : UIDJar()
{
  _urlFolder=urlFolder;
  setupFiles();
  loadLists();
}

IMAP4_UIDJar::~IMAP4_UIDJar()
{
}

void IMAP4_UIDJar::setupFiles()
{
  rcvFileName=_urlFolder+"/rcvuids";
  delFileName=_urlFolder+"/deluids";
}

void IMAP4_UIDJar::rcvInsert(const char* uid, const char* urlMessage, unsigned int rcvTime)
{
  UIDINFO uidData;
  uidData.info=urlMessage;
  uidData.rcvTime=rcvTime;
  // Insert the deleted UID
  if( strlen(uid) && strlen(urlMessage) )
	  rcvList.insert(UIDValuePair((string)uid, uidData));
}

