#include <metaformatcontrol.h>
#include <kconfig.h>
#include <qstringlist.h>
#include <qstring.h>
#include <stdio.h>

extern KConfig *GlobalConfig;

MetaFormatControl *MetaFormatControl::thisInstance;

MetaFormatControl::MetaFormatControl()
{
	refresh();
}

MetaFormatControl::~MetaFormatControl()
{
	// save to config file
}

void MetaFormatControl::refresh()
{
	QStrList activeRules;
	if(!GlobalConfig->hasGroup("HTML Parser"))
	{
		printf("Non-existent group.\n");
		return;
	}
	GlobalConfig->setGroup("HTML Parser");
	// reply data
	GlobalConfig->readListEntry("Reply pattern", replyData);
	enableReplyTags=enableBlockReplyTags=replyData.count()!=0;
	// "Xxxxx wrote:"
	GlobalConfig->readListEntry("Wrote pattern", wroteData);
	enableWroteSequence=wroteData.count()!=0;
#ifdef DEBUG_MFC
	printf("WROTE: %d, REPLY: %d\n", enableWroteSequence, enableReplyTags);
#endif
	GlobalConfig->readListEntry("Active rules", activeRules);
	enableAnySequence=activeRules.count()!=0;
	for(QStrListIterator it(activeRules); it.current(); ++it)
	{
		QString group=QString("HTML Rule ")+(*it);
		if(GlobalConfig->hasGroup(group))
		{
			GlobalConfig->setGroup(group);
			QString beginPattern=GlobalConfig->readEntry("Begin pattern");
			QString bodyPattern=GlobalConfig->readEntry("Body pattern");
			QString endPattern=GlobalConfig->readEntry("End pattern");
			if(beginPattern.isEmpty() && endPattern.isEmpty() && !bodyPattern.isEmpty())
				anyData.append(MetaFormatControl::SeqTag(bodyPattern, (*it)));
			if(!beginPattern.isEmpty() && !endPattern.isEmpty() && !bodyPattern.isEmpty())
				anyData.append(MetaFormatControl::SeqTag(beginPattern, bodyPattern, endPattern, (*it)));
		}
	}
		
}

MetaFormatControl *MetaFormatControl::ref()
{
	if(!MetaFormatControl::thisInstance)
	{
		MetaFormatControl::thisInstance=new MetaFormatControl();
	}
	
	return MetaFormatControl::thisInstance;
}

MetaFormatControl::SeqTag::SeqTag()
{
}

MetaFormatControl::SeqTag::SeqTag(const QString &_beginPattern, const QString &_textPattern, const QString &_endPattern, const QString &_tag)
{
	beginPattern=_beginPattern;
	textPattern=_textPattern;
	endPattern=_endPattern;
	tag=_tag;
	strip=true;
}

MetaFormatControl::SeqTag::SeqTag(const QString &_textPattern, const QString &_tag)
{
	textPattern=_textPattern;
	tag=_tag;
	strip=false;
}
