/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: carddialogwidget.cpp,v 1.3 2001/05/19 10:56:35 alex Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <ebutton.h>
#include <contactobj.h>
#include <cardtileview.h>
#include <cardclasses.h>
#include <ataddressbook.h>
#include <templateview.h>
#include <pixlibrary.h>

#include <contacttogroupdialog.h>

#include <carddialogwidget.h>
#include <cardtileview.h>
#include <cardtilewidget.h>
#include <toolbarseparator.h>
#include <ebutton.h>
#include <etoolbarbutton.h>
#include <cardview.h>
#include <vobject.h>
#include <composerwindow.h>

#include <carddialog.h>
#include <ecollection.h>
#include <qwidgetstack.h>
#include <qmessagebox.h>
#include <miscfunctions.h>
#include <stdio.h>

#include <kiconloader.h>

//#define DEBUG_CARDDIALOGWIDGET

#define IDSTRING "CardDialogWidget: "

#define addToGroupButton  (((CardDialog *)parentWidget())->addToGroupButton)
#define upArrowButton			(((CardDialog *)parentWidget())->upArrowButton)
#define downArrowButton		(((CardDialog *)parentWidget())->downArrowButton)
#define saveButton				(((CardDialog *)parentWidget())->saveButton)
#define clearButton				(((CardDialog *)parentWidget())->clearButton)
#define helpButton				(((CardDialog *)parentWidget())->helpButton)
#define printButton				(((CardDialog *)parentWidget())->printButton)
#define sendMailButton		(((CardDialog *)parentWidget())->sendMailButton)

CardPixmaps *CardPixmaps::cPixmaps = 0;

CardPixmaps::CardPixmaps()
{
		_other[0] = BarIcon("other-normal");
		_other[1] = BarIcon("other-focus");
		_other[2] = BarIcon("other-focus");
		_personal[0] = BarIcon("personal-normal");
		_personal[1] = BarIcon("personal-focus");
		_personal[2] = BarIcon("personal-focus");
		_summary[0] = BarIcon("summary-normal");
		_summary[1] = BarIcon("summary-focus");
		_summary[2] = BarIcon("summary-focus");
		_work[0] = BarIcon("work-normal");
		_work[1] = BarIcon("work-focus");
		_work[2] = BarIcon("work-focus");
}
QPixmap &CardPixmaps::other(int c)
{
	return _other[c%3];
}
QPixmap &CardPixmaps::personal(int c)
{
	return _personal[c%3];
}
QPixmap &CardPixmaps::summary(int c)
{
	return _summary[c%3];
}
QPixmap &CardPixmaps::work(int c)
{
	return _work[c%3];
}
CardPixmaps *CardPixmaps::thisInstance()
{
	if (!cPixmaps)
		cPixmaps= new CardPixmaps;
	return cPixmaps;
}


#define IDSTRING "CardDialogWidget: "

CardDialogWidget::CardDialogWidget(ContactObject *contact, QWidget *parent, const char *name) :
	CardDialogWidgetBase(parent, name), TemplateView(contact)
{
	_personal=0;
	_business=0;
	_other=0;
	_summary=0;
	setCard(contact);
	initGUI();
}

void CardDialogWidget::initGUI()
{
  switcher->setFocusPolicy(QWidget::TabFocus);
  switcher->setBackgroundMode(QWidget::PaletteBackground);
  switcher->setFontPropagation(QWidget::SameFont);
  switcher->setPalettePropagation(QWidget::SameFont);
	switcher->setPersistence(true);
	switcher->setSpacing(32);
	// buttons
	other=new EButton(BarIcon("newcontact-other"), switcher);
	personal=new EButton(BarIcon("newcontact-personal"), switcher);
	summary=new EButton(BarIcon("newcontact-summary"), switcher);
	work=new EButton(BarIcon("newcontact-business"), switcher);

	switcher->addButton(personal);
	switcher->addButton(work);
	switcher->addButton(other);
	switcher->addButton(summary);
	
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Adding business widget\n");
#endif
	stack->addWidget((_business = new BusinessWidget(&businessE)),1);
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Adding personal widget\n");
#endif
	stack->addWidget((_personal = new PersonalWidget(&personalE)),0);
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Adding summary widget\n");
#endif
	stack->addWidget((_summary = new SummaryWidgetBase),3);
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Adding other widget\n");
#endif
	stack->addWidget((_other = new OtherWidget(&otherE)),2);
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Ready\n");
#endif
	stack->raiseWidget(0);
	connect(_business, SIGNAL(urlUpdatedSignal(const QStringList &)),
		_personal, SLOT(urlUpdated(const QStringList &)));
	connect(_personal, SIGNAL(urlUpdatedSignal(const QStringList &)),
		_business, SLOT(urlUpdated(const QStringList &)));
	connect(_personal, SIGNAL(changedSignal()), this, SLOT(changed()));
	connect(_business, SIGNAL(changedSignal()), this, SLOT(changed()));
	connect(_other, SIGNAL(changedSignal()), this, SLOT(changed()));
}

void CardDialogWidget::changed()
{
	if(parentWidget())
	{
		((CardDialog *)parentWidget())->setCaption(personalE.card(), true);
	}
}


ContactObject *CardDialogWidget::card()
{
	return _card;
}


void CardDialogWidget::setCard(ContactObject *obj)
{
	_card=obj;
	if(card())
	{
		initFrames();
		if(_personal) _personal->setItems(&personalE);
		if(_business) _business->setItems(&businessE);
		if(_other) _other->setItems(&otherE);
		if(_summary) setupSummary();
	}
	if(card()->emails().count() && ContactToGroupDialog::checkGroups(card()->emails()[card()->defaultEmail()]))
	{
#ifdef DEBUG_CARDDIALOGWIDGET
		printf(IDSTRING"Found free group...\n");
#endif
		addToGroupButton->setDisabled(false);
	}
#ifdef DEBUG_CARDDIALOGWIDGET
		printf(IDSTRING"Found e-mail address...\n");
#endif
	if(card()->emails().count())
	{
		sendMailButton->setDisabled(false);
	}
}

void CardDialogWidget::initFrames()
{
	// the parsing & stuff for initing the frames
	// e-mails
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Setting up Emails\n");
#endif
	while(emailsE.emails().count())
		emailsE.removeMail(0);
	emailsE.setDefaultEmail(-1);
	for(int i=0;i<card()->emails().count();i++)
	{
		emailsE.addEmail(card()->emails()[i], i == card()->defaultEmail());
	}
	// urls
	urlE=card()->URLs();
	// Business:
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Setting up Business stuff\n");
#endif
	businessE.setRole(card()->role());
	businessE.setTitle(card()->title());
	businessE.setOrg(card()->org());
	businessE.setUrls(&urlE);
	businessE.setEmails(&emailsE);
	businessE.address().setPoBox(card()->workAdr()[0].simplifyWhiteSpace());
	businessE.address().setDetails(card()->workAdr()[1].simplifyWhiteSpace());
	businessE.address().setStreetName(card()->workAdr()[2].simplifyWhiteSpace());
	businessE.address().setCity(card()->workAdr()[3].simplifyWhiteSpace());
	businessE.address().setCode(card()->workAdr()[5].simplifyWhiteSpace());
	businessE.address().setCountry(card()->workAdr()[6].simplifyWhiteSpace());
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Country(card): <%s>\n",(const char *)card()->workAdr()[6].simplifyWhiteSpace());
	printf(IDSTRING"Country(busi): <%s>\n",(const char *)businessE.address().country());
#endif
	// no phones so far...
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Setting up Personal stuff\n");
#endif
	if(card()->n()[2].length()>1)
	{
		personalE.setName(card()->n()[0] + " " +card()->n()[2]);
		personalE.setInitial("");
	}
	else
	{
		personalE.setName(card()->n()[0]);
		personalE.setInitial(card()->n()[2]);
	}
	personalE.setUrls(&urlE);
	personalE.setFamilyName(card()->n()[1]);
	personalE.setPrefix(card()->n()[3]);
	personalE.setCard(card()->fn());
	personalE.setEmails(&emailsE);
	personalE.address().setPoBox(card()->homeAdr()[0].simplifyWhiteSpace());
	personalE.address().setDetails(card()->homeAdr()[1].simplifyWhiteSpace());
	personalE.address().setStreetName(card()->homeAdr()[2].simplifyWhiteSpace());
	personalE.address().setCity(card()->homeAdr()[3].simplifyWhiteSpace());
	personalE.address().setCode(card()->homeAdr()[5].simplifyWhiteSpace());
	personalE.address().setCountry(card()->homeAdr()[6].simplifyWhiteSpace());
	// the phones
	QStringList types[2], numbers[2];
	for(int i=0;i<card()->phoneType().count();i++)
	{
		if(card()->phoneType()[i].find("home",0,false)!=-1)
		{
			types[0].append(card()->phoneType()[i]);
			numbers[0].append(card()->phone()[i]);
		}
		else
		{
			types[1].append(card()->phoneType()[i]);
			numbers[1].append(card()->phone()[i]);
		}
	}
	personalE.setPhones(setPhones(types[0], numbers[0], "home"));
	businessE.setPhones(setPhones(types[1], numbers[1], "work"));
	// the "others"
	otherE.setBday(card()->bday());
	otherE.setNotes(card()->notes());
	otherE.setCategories(card()->categories());
	switch(card()->security())
	{
		case ContactObject::Private:
			otherE.setSecurity("Private");
			break;
		case ContactObject::Public:
			otherE.setSecurity("Public");
			break;
		case ContactObject::Confidential:
			otherE.setSecurity("Confidential");
	}
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"Finished\n");
#endif
}

void CardDialogWidget::buttonClicked(int button)
{
	if(button==3)
	{
#ifdef DEBUG_CARDDIALOGWIDGET
		printf(IDSTRING"Building summary...\n");
#endif
		setupSummary();
#ifdef DEBUG_CARDDIALOGWIDGET
		printf(IDSTRING"Summary done.\n");
#endif
	}
	stack->raiseWidget(button);
}

CardListPhones *CardDialogWidget::setPhones(QStringList types, QStringList numbers, QString where)
{
	CardListPhones *result = new CardListPhones;
	for(int i=0;i<types.count();i++)
	{
#ifdef DEBUG_CARDDIALOGWIDGET
		printf(IDSTRING"[%s]: type: <%s> , number: %s\n",(const char *)where,
			(const char *)types[i], (const char *)numbers[i]);
#endif
		QStringList typ=split(types[i],',');
		QString simplifiedTypes=QString::null;
		for(int j=0;j<typ.count();j++)
			if(typ[i].find(where,0,false)==-1)
				simplifiedTypes += QString(" ") + typ[i];
		simplifiedTypes = simplifiedTypes.simplifyWhiteSpace();
		if(!numbers[i].isEmpty())
		{
			if(simplifiedTypes.isEmpty())
				simplifiedTypes="fixed";
			CardPhone *cp;
			cp=new CardPhone;
			cp->setType(simplifiedTypes);
			cp->setNumber(numbers[i]);
			result->addPhone(cp);
		}
	}
#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"result count: %d\n", result->count());
#endif
	return result;
}

void CardDialogWidget::moveEvent(QMoveEvent *me)
{
	if(parentWidget())
	{
//		parentWidget()->resize(parentWidget()->width()+(me->pos().x() - me->oldPos().x()),
//				height()+ ((KMainWindow *)parentWidget())->toolBar()->height() +
//				(me->pos().y() - me->oldPos().y()));
//		printf("Height= %d\n", height() + (me->pos().y() - me->oldPos().y()));
		emit(newHeight(height() + (me->pos().y() - me->oldPos().y())));
	}
}


void CardDialogWidget::clearCard()
{
//	titlesE.clear();
//	contentsE.clear();
	urlE.clear();
	emailsE.emails().clear();
	businessE.clear();
	personalE.clear();
	otherE.clear();
	businessE.setPhones(setPhones(QStringList(), QStringList(), "work"));
	personalE.setPhones(setPhones(QStringList(), QStringList(), "home"));
	_business->setItems(&businessE);
	_personal->setItems(&personalE);
	_other->setItems(&otherE);
}

void CardDialogWidget::closeCard()
{
	if(parentWidget())
		parentWidget()->close();
	else
		close();
}

void CardDialogWidget::groupCard()
{
	QString s;
	s.sprintf("\"%s %s\" <%s>", (const char *)personalE.name(),
		(const char *)personalE.familyName(),
		(const char *)emailsE.emails()[emailsE.defaultEmail()]);
//#ifdef DEBUG_CARDDIALOGWIDGET
	printf(IDSTRING"adding |%s| to a group\n", (const char *)s);
//#endif
	ContactToGroupDialog *gd=new ContactToGroupDialog(s,this);
	gd->setCaption(emailsE.emails()[emailsE.defaultEmail()]);
	gd->show();
	addToGroupButton->setDisabled(ContactToGroupDialog::checkGroups(emailsE.emails()[emailsE.defaultEmail()]));
}

void CardDialogWidget::helpCard()
{
	printf(IDSTRING"HELP not implemented\n");
}

void CardDialogWidget::nextCard()
{
	CardView *p;
#ifdef DEBUG_CDW
	printf(IDSTRING" 1 %p\n", parentWidget());
	printf(IDSTRING" 2 %p\n", parentWidget()->parentWidget());
	printf(IDSTRING" 3 %p\n", parentWidget()->parentWidget()->parentWidget());
	printf(IDSTRING" 4 %p\n", parentWidget()->parentWidget()->parentWidget()->parentWidget());
	printf(IDSTRING" 5 %p\n", parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget());
#endif
	// parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget() is CardView
	p = (CardView *)parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget();
	QList<VObject> contactList=p->vFolder()->objectList();
	printf(IDSTRING" %d\n", contactList.find(card()));
	int next=contactList.find(card())+1;
	if(next==contactList.count())
	{
		return;
	}
	setCard((ContactObject *)contactList.at(next));
}

void CardDialogWidget::prevCard()
{
	CardView *p;
	// parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget() is CardView
	p = (CardView *)parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget();
	QList<VObject> contactList=p->vFolder()->objectList();
	int next=contactList.find(card())-1;
	if(next<0)
	{
		return;
	}
	setCard((ContactObject *)contactList.at(next));
}

void CardDialogWidget::printCard()
{
}

void CardDialogWidget::saveCard()
{
	save();
}

void CardDialogWidget::saveCloseCard()
{
	saveCard();
	closeCard();
}

void CardDialogWidget::sendCard()
{
	ComposerWindow::openComposer(QString("\"")+card()->n()[0]+" "+card()->n()[1]+"\" "
		"<"+card()->emails()[card()->defaultEmail()]+">", ComposerWindow::UsingRecipient);
}

void CardDialogWidget::save()
{
	// setting FN
	card()->setFn(personalE.card());
	//setting N
	QStringList NList;
	NList=personalE.name();
	NList.append(personalE.familyName());
	NList.append(personalE.initial());
	NList.append(personalE.prefix());
	NList.append(card()->n()[5]);
	card()->setN(NList);
	// setting work Address
	QStringList adr;
	adr.append(businessE.address().poBox());
	adr.append(businessE.address().details());
	adr.append(businessE.address().streetName());
	adr.append(businessE.address().city());
	adr.append(card()->workAdr()[4]);
	adr.append(businessE.address().code());
	adr.append(businessE.address().country());
	card()->setWorkAdr(adr);
	adr.clear();
	// setting home Address
	adr.append(personalE.address().poBox());
	adr.append(personalE.address().details());
	adr.append(personalE.address().streetName());
	adr.append(personalE.address().city());
	adr.append(card()->homeAdr()[4]);
	adr.append(personalE.address().code());
	adr.append(personalE.address().country());
	card()->setHomeAdr(adr);
	// setting emails (including default)
	card()->setDefaultEmail(businessE.emails()->defaultEmail());
	card()->setEmails(businessE.emails()->emails());
	// setting work phones
	QValueList<CardPhone *> p;
	QStringList nos, tys;
	p=businessE.phones().phones();
	for(int i=0;i<p.count();i++)
	{
		nos.append(p[i]->number());
		tys.append(QString("work,")+p[i]->type());
	}
	// setting home phones
	p=personalE.phones().phones();
	for(int i=0;i<p.count();i++)
	{
		nos.append(p[i]->number());
		tys.append(QString("home,")+p[i]->type());
	}
	card()->setPhoneType(tys);
	card()->setPhone(nos);
	// setting security
	card()->setSecurity(ContactObject::Private);
	if(otherE.security().lower()=="confidential")
		card()->setSecurity(ContactObject::Confidential);
	if(otherE.security().lower()=="public")
		card()->setSecurity(ContactObject::Public);
	// setting category
	card()->setCategories(otherE.categories());
	// setting notes
	card()->setNotes(otherE.notes());
	// setting birthday
	card()->setBday(otherE.bday());
	// setting role
	card()->setRole(businessE.role());
	// setting org
	card()->setOrg(businessE.org());
	// setting title
	card()->setTitle(businessE.title());
	// setting nick
	card()->setNick(personalE.nick());
	// setting URLs
	card()->setURLs(urlE);

	AddressBook::thisInstance()->removeContact(card()->url());
	AddressBook::thisInstance()->addContact(card());
	if(parentWidget())
	{
		((CardDialog *)parentWidget())->setCaption(personalE.card(), false);
	}
	card()->save();
	CardDialog *pw=(CardDialog *)parentWidget();
	card()->updateViews(this);
	if(pw)
		pw->setNewCard(false);
}


void CardDialogWidget::setupSummary()
{
	// the name and nick.
	titlesE="Name:";
	contentsE=personalE.card().stripWhiteSpace();
	if(!personalE.nick().stripWhiteSpace().isEmpty())
		contentsE+=" (" + personalE.nick().stripWhiteSpace() + ")";
	titlesE+="\n";
	contentsE+="\n";
	
	// the title
	if(!businessE.title().isEmpty())
	{
		titlesE+="Title\n";
		contentsE+=businessE.title() + "\n";
	}
	// the role
	if(!businessE.role().isEmpty())
	{
		titlesE+="Role\n";
		contentsE+=businessE.role() + "\n";
	}
	// the org
	if(!businessE.org().isEmpty())
	{
		titlesE+="Organization\n";
		contentsE+=businessE.org() + "\n";
	}
	// home address
	if(!personalE.address().poBox().isEmpty() ||
		!personalE.address().details().isEmpty() ||
		!personalE.address().streetName().isEmpty() ||
		!personalE.address().city().isEmpty() ||
		!personalE.address().code().isEmpty() ||
		!personalE.address().country().isEmpty())
	{
		titlesE+="Home address:";
		int flag=0;
		if(!personalE.address().poBox().isEmpty())
		{
			contentsE+=personalE.address().poBox() +", ";
			flag=1;
		}
		if(!personalE.address().details().isEmpty())
		{
			contentsE+=personalE.address().details() +", ";
			flag=1;
		}
		if(!personalE.address().streetName().isEmpty())
		{
			contentsE+=personalE.address().streetName() + ",";
			flag=1;
		}
		if(flag)
			contentsE+="\n";
		if(!personalE.address().city().isEmpty())
		{
			contentsE+=personalE.address().city() + ((flag)?", ":"\n");
			if(!flag) flag=1;
			else flag=2;
		}
		if(!personalE.address().code().isEmpty())
		{
			contentsE+=personalE.address().code() +", ";
			if(!flag) flag=1;
			else flag=2;
		}
		if(!personalE.address().country().isEmpty())
		{
			contentsE+=personalE.address().country();
			if(!flag) flag=1;
			else flag=2;
		}
		if(flag)
			contentsE+="\n";
		for(int i=0;i<flag;i++)
			titlesE+="\n";
	}
	// Work address
	if(!businessE.address().poBox().isEmpty() ||
		!businessE.address().details().isEmpty() ||
		!businessE.address().streetName().isEmpty() ||
		!businessE.address().city().isEmpty() ||
		!businessE.address().code().isEmpty() ||
		!businessE.address().country().isEmpty())
	{
		titlesE+="Work address:";
		int flag=0;
		if(!businessE.address().poBox().isEmpty())
		{
			contentsE+=businessE.address().poBox() +", ";
			flag=1;
		}
		if(!businessE.address().details().isEmpty())
		{
			contentsE+=businessE.address().details() +", ";
			flag=1;
		}
		if(!businessE.address().streetName().isEmpty())
		{
			contentsE+=businessE.address().streetName() +",";
			flag=1;
		}
		if(flag)
			contentsE+="\n";
		if(!businessE.address().city().isEmpty())
		{
			contentsE+=businessE.address().city() + ((flag)?", ":"\n");
			if(!flag) flag=1;
			else flag=2;
		}
		if(!businessE.address().code().isEmpty())
		{
			contentsE+=businessE.address().code() +", ";
			if(!flag) flag=1;
			else flag=2;
		}
		if(!businessE.address().country().isEmpty())
		{
			contentsE+=businessE.address().country();
			if(!flag) flag=1;
			else flag=2;
		}
		if(flag)
			contentsE+="\n";
		for(int i=0;i<flag;i++)
			titlesE+="\n";
	}

	if(emailsE.emails().count())
	{
		titlesE+="E-mail:";
		if(!emailsE.defaultEmail()!=-1)
		{
			titlesE+=" (def)\n";
			contentsE+=emailsE.emails()[emailsE.defaultEmail()] + "\n";
		}
		// get maximum 4 other e-mails
		for(int i=0;i<emailsE.emails().count() && i<4;i++)
			if(i!=emailsE.defaultEmail())
			{
				titlesE+="\n";
				contentsE+=emailsE.emails()[i]+"\n";
			}
	}
	if(personalE.phones().count() || businessE.phones().count())
		titlesE+="Phones:";
	
	if(businessE.phones().count())
	{
		// set up work fones
		titlesE+="  work";
		// get max 4 phones
		for(int i=0;i<businessE.phones().count() && i<4;i++)
		{
			contentsE+=businessE.phones().phones()[i]->number();
			contentsE+="\t\t(";
			contentsE+=businessE.phones().phones()[i]->type().lower();
			contentsE+=")\n";
			titlesE+="\n";
		}
	}
	if(personalE.phones().count())
	{
		// set up home fones
		titlesE+="home";
		for(int i=0;i<personalE.phones().count() && i<4;i++)
		{
			contentsE+=personalE.phones().phones()[i]->number();
			contentsE+="\t\t(";
			contentsE+=personalE.phones().phones()[i]->type().lower();
			contentsE+=")\n";
			titlesE+="\n";
		}
	}
	if(urlE.count())
	{
		titlesE+="URL:";
		// set up work url (first 3 URLs)
		for(int i=0;i<urlE.count() && i<3;i++)
		{
			contentsE+=urlE[i] + "\n";
			titlesE+="\n";
		}
	}
	_summary->titlesLabel->setText(titlesE);
	_summary->contentsLabel->setText(contentsE);

}
