/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <cardclasses.h>
#include <businesswidget.h>
#include <phonewidget.h>
#include <mailwidget.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <stdio.h>
#include <miscfunctions.h>
#include <countriesclass.h>

BusinessWidget::BusinessWidget(CardBusinessElements *elements, QWidget *parent, const char *name) :
	BusinessWidgetBase(parent, name)
{
	setItems(elements);
}

void BusinessWidget::setItems(CardBusinessElements *_it)
{
	_items=_it;
	if(!_it)
		return;
	// setting all the labels & stuff...
	// title
	titleCombo->setEditText(items()->title());
	// org
	orgEdit->setText(items()->org());
	// role
	roleCombo->setEditText(items()->role());
	// address
	poboxEdit->setText(items()->address().poBox());
	streetEdit->setText(items()->address().streetName());
	detailsEdit->setText(items()->address().details());
	codeEdit->setText(items()->address().code());
	cityEdit->setText(items()->address().city());
	countryBox->setEditText(items()->address().country());
	QString myCountry=items()->address().country();
	countryBox->insertStringList(CountriesClass::thisInstance()->countries());
	if(myCountry.stripWhiteSpace().isEmpty())
	{
		QStringList domains;
		if(items()->emails()->defaultEmail()!=-1)
			domains=split(items()->emails()->emails()[items()->emails()->defaultEmail()], '.');
		if(domains.count()>1)
			myCountry=CountriesClass::thisInstance()->country(domains[domains.count()-1]);
		else
			myCountry="";
	}
	updateComboBox(countryBox, myCountry);
	// email
	if(items()->emails()->defaultEmail()!=-1)
		emailsButton->setText(items()->emails()->emails()[items()->emails()->defaultEmail()]);
	else
		emailsButton->setText("No e-mails");
	// phone
	if(items()->phones().phones().count())
		phoneButton->setText(items()->phones().phones()[0]->number());
	else
		phoneButton->setText("No phones");
	// url
	urlBox->clear();
	if(items()->urls())
		urlBox->insertStringList(*(items()->urls()));
	clearUrlButton->setEnabled(items()->urls()->count()!=0);
}

CardBusinessElements *BusinessWidget::items()
{
	return _items;
}

void BusinessWidget::addressCityChanged(const QString &str)
{
	items()->address().setCity(str);
	emit(changedSignal());
}

void BusinessWidget::addressCodeChanged(const QString &str)
{
	items()->address().setCode(str);
	emit(changedSignal());
}

void BusinessWidget::addressCountryChanged(const QString &str)
{
	items()->address().setCountry(str);
	emit(changedSignal());
}

void BusinessWidget::addressDetailsChanged(const QString &str)
{
	items()->address().setDetails(str);
	emit(changedSignal());
}

void BusinessWidget::addressPoBoxChanged(const QString &str)
{
	items()->address().setPoBox(str);
	emit(changedSignal());
}

void BusinessWidget::addressStreetChanged(const QString &str)
{
	items()->address().setStreetName(str);
	emit(changedSignal());
}

void BusinessWidget::orgChanged(const QString &str)
{
	items()->setOrg(str);
	emit(changedSignal());
}

void BusinessWidget::roleChanged(const QString &str)
{
	items()->setRole(str);
	emit(changedSignal());
}

void BusinessWidget::showEmails()
{
	MailWidget *mw= new MailWidget(emailsButton, items()->emails(), this);
	mw->move(emailsButton->mapToGlobal(QPoint(0,25)));
	mw->show();
}

void BusinessWidget::showHomePhones()
{
	PhoneWidget *pw= new PhoneWidget(phoneButton, &(items()->phones()), this);
	pw->move(phoneButton->mapToGlobal(QPoint(0,25)));
	pw->show();
}

void BusinessWidget::clearUrl()
{
	int idx=-1;
	for(int i=0;i<urlBox->count();i++)
		if(urlBox->text(i)==urlBox->currentText())
		{
			idx=i;
			i=urlBox->count();
		}
	urlBox->setEditText("");
	if(idx!=-1)
	{
		// erase the element
		urlBox->removeItem(idx);
	}
	if(urlBox->count())
		urlBox->setCurrentItem(0);
	else
		clearUrlButton->setEnabled(false);
	QStringList result;
	for(int i=0;i<urlBox->count();i++)
		result.append(urlBox->text(i));
	emit(changedSignal());
	emit(urlUpdatedSignal(result));
}

void BusinessWidget::titleChanged(const QString &str)
{
	items()->setTitle(str);
	emit(changedSignal());
}

void BusinessWidget::urlChanged(const QString &str)
{
	if(items()->urls()->count() != urlBox->count() && 
			items()->urls()->grep(str).count()==0 && 
			!str.isEmpty())
	{
		items()->urls()->append(str);
		emit(urlUpdatedSignal(*items()->urls()));
	}
	if(items()->urls()->count())
		clearUrlButton->setEnabled(true);
	emit(changedSignal());
}

void BusinessWidget::urlUpdated(const QStringList &l)
{
	urlBox->clear();
	urlBox->insertStringList(l);
}
