/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <ebutton.h>
#include <etogglebutton.h>
#include <qframe.h>
#include <qfont.h>
#include <qfontmetrics.h>
#include <qwidgetstack.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistbox.h>
#include <qcombobox.h>
//#include <miscfunctions.h>
#include <qmultilineedit.h>


#define defaultActionWidgetLength		400
#define defaultActionWidgetHeight		150


class ActionWidget : public QFrame
{
	Q_OBJECT
	
public:
	QFont *qf;
	QFontMetrics *fm;
	ActionWidget(QWidget *parent=NULL, QString name=QString::null,
			QFont *qfont=NULL, QFontMetrics *fontMetrics=NULL);
	void setUpDialog();
	void setGeometry(int xx, int yy, int w, int h, int ddx=0, int ddy=0);
signals:
	void metaLines(QString result);

protected slots:	
	void raiseFrame(int index);

protected:
	int x,y;
	int DX,DY;
	int height;
	int width;
	/**
	 *	The frame selector:
	 */
	QComboBox *selector;
	QLabel *selectorLabel;
	/**
	 *	The frames:
	 */
	QWidgetStack *frames;
	QFrame *messageBox;
	QFrame *runProgram;
	QFrame *playSound;
	QFrame *sendMail;
	
	void setupMessageBox();
	void setupRunProgram();
	void setupPlaySound();
	void setupSendMail();
	void setupSelector();

	/**
	 *	MessageBox:
	 */
	QLabel *messageLabel;
	QLabel *titleLabel;
	QMultiLineEdit *message;
	QLineEdit *title;
	EToggleButton *beep;
	QLabel *beepText;
	/**
	 *	runProgram:
	 */
	QLabel *commandLabel;
	QLabel *parametersLabel;
	QLabel *wrapLabel;
	QLineEdit *command;
	QMultiLineEdit *parameters;
	EButton *browseCommand;
	EButton *browseParameters;
	EToggleButton *wrap;
	/**
	 *	playSound:
	 */
	QLabel *playerLabel;
	QLabel *soundLabel;
	QListBox *playersList;
	EButton *setDefaultPlayer;
	EButton *addPlayer;
	EButton *removePlayer;
	QLineEdit *sound;
	EButton *browseSound;
	/**
	 *	sendMail
	 */
	EButton *mailWindowButton;
	QLabel *information;
};

